/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.dtd.contentmodel.CMDTDContentModelProvider;
import org.eclipse.lemminx.extensions.dtd.participants.DTDCodeLensParticipant;
import org.eclipse.lemminx.extensions.dtd.participants.DTDDefinitionParticipant;
import org.eclipse.lemminx.extensions.dtd.participants.DTDDocumentLinkParticipant;
import org.eclipse.lemminx.extensions.dtd.participants.DTDHighlightingParticipant;
import org.eclipse.lemminx.extensions.dtd.participants.DTDReferenceParticipant;
import org.eclipse.lemminx.extensions.dtd.participants.diagnostics.DTDDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.services.extensions.IReferenceParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lsp4j.InitializeParams;

public class DTDPlugin
implements IXMLExtension {
    private IDiagnosticsParticipant diagnosticsParticipant;
    private final IDefinitionParticipant definitionParticipant = new DTDDefinitionParticipant();
    private final IHighlightingParticipant highlightingParticipant = new DTDHighlightingParticipant();
    private final IReferenceParticipant referenceParticipant = new DTDReferenceParticipant();
    private final ICodeLensParticipant codeLensParticipant = new DTDCodeLensParticipant();
    private DTDDocumentLinkParticipant documentLinkParticipant;

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        CMDTDContentModelProvider modelProvider = new CMDTDContentModelProvider(registry.getResolverExtensionManager());
        ContentModelManager modelManager = (ContentModelManager)registry.getComponent(ContentModelManager.class);
        modelManager.registerModelProvider(modelProvider);
        this.diagnosticsParticipant = new DTDDiagnosticsParticipant(modelManager);
        registry.registerDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.registerDefinitionParticipant(this.definitionParticipant);
        registry.registerHighlightingParticipant(this.highlightingParticipant);
        registry.registerReferenceParticipant(this.referenceParticipant);
        registry.registerCodeLensParticipant(this.codeLensParticipant);
        URIResolverExtensionManager resolverManager = (URIResolverExtensionManager)registry.getComponent(URIResolverExtensionManager.class);
        this.documentLinkParticipant = new DTDDocumentLinkParticipant(resolverManager);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.unregisterDiagnosticsParticipant(this.diagnosticsParticipant);
        registry.unregisterDefinitionParticipant(this.definitionParticipant);
        registry.unregisterHighlightingParticipant(this.highlightingParticipant);
        registry.unregisterReferenceParticipant(this.referenceParticipant);
        registry.unregisterCodeLensParticipant(this.codeLensParticipant);
        registry.unregisterDocumentLinkParticipant(this.documentLinkParticipant);
    }
}

