/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.enums;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.enums.ConstantValueUnionScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.s.model.js.enums.VariableScoutEnum;
import org.eclipse.scout.sdk.core.s.model.js.prop.IScoutJsPropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeFulfillsEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.ITypeOf;
import org.eclipse.scout.sdk.core.typescript.model.api.IVariable;

public class ES6ClassTypeAliasScoutEnum
implements IScoutJsEnum {
    private final ScoutJsModel m_scoutJsModel;
    private final IES6Class m_class;
    private final IScoutJsEnum m_wrappedEnum;

    protected ES6ClassTypeAliasScoutEnum(ScoutJsModel scoutJsModel, IES6Class clazz, IScoutJsEnum wrappedEnum) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_class = clazz;
        this.m_wrappedEnum = wrappedEnum;
    }

    public static Optional<IScoutJsEnum> create(ScoutJsModel owner, IES6Class clazz) {
        if (owner == null || clazz == null || !clazz.isTypeAlias()) {
            return Optional.empty();
        }
        Optional aliasedType = Optional.of(clazz).flatMap(IES6Class::aliasedDataType);
        if (aliasedType.filter(dataType -> "EnumObject".equals(dataType.name())).isPresent()) {
            return aliasedType.stream().flatMap(IDataType::typeArguments).findFirst().filter(ITypeOf.class::isInstance).map(ITypeOf.class::cast).flatMap(ITypeOf::dataTypeOwner).filter(IVariable.class::isInstance).map(IVariable.class::cast).flatMap(variable -> VariableScoutEnum.create(owner, variable)).map(scoutJsEnum -> new ES6ClassTypeAliasScoutEnum(owner, clazz, (IScoutJsEnum)scoutJsEnum));
        }
        return aliasedType.filter(dataType -> IDataType.DataTypeFlavor.Union == dataType.flavor()).flatMap(unionDataType -> ConstantValueUnionScoutEnum.create(owner, unionDataType)).map(scoutJsEnum -> new ES6ClassTypeAliasScoutEnum(owner, clazz, (IScoutJsEnum)scoutJsEnum));
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    protected IScoutJsEnum wrappedEnum() {
        return this.m_wrappedEnum;
    }

    @Override
    public String name() {
        return this.declaringClass().name();
    }

    @Override
    public IES6Class declaringClass() {
        return this.m_class;
    }

    @Override
    public String referenceName() {
        return this.wrappedEnum().referenceName();
    }

    @Override
    public INodeElement topLevelReference() {
        return this.wrappedEnum().topLevelReference();
    }

    @Override
    public List<String> constants() {
        return this.wrappedEnum().constants();
    }

    @Override
    public Stream<? extends IScoutJsPropertyValue> createPropertyValues(ScoutJsProperty property) {
        return this.wrappedEnum().createPropertyValues(property);
    }

    @Override
    public boolean fulfills(IDataType dataType) {
        return new DataTypeFulfillsEvaluator(dt -> dt == this.declaringClass() || this.wrappedEnum().fulfills((IDataType)dt)).fulfills(dataType);
    }

    public String toString() {
        return this.declaringClass().toString();
    }
}

