/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderFactory;
import org.eclipse.jst.jee.model.internal.EAR5ModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EAR5ModelProviderFactory
implements IModelProviderFactory {
    private static Map<IProject, IModelProvider> providersMap = new HashMap<IProject, IModelProvider>();
    private static IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResource project = event.getResource();
            if (project instanceof IProject) {
                providersMap.remove(project);
            }
        }
    };

    static {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(listener, 6);
    }

    public synchronized IModelProvider create(IProject project) {
        IModelProvider provider = providersMap.get(project);
        if (provider == null) {
            provider = new EAR5ModelProvider(project);
            providersMap.put(project, provider);
        }
        return provider;
    }

    public IModelProvider create(IVirtualComponent component) {
        return this.create(component.getProject());
    }
}

