/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class JavaConsoleTracker
implements IPatternMatchListenerDelegate {
    private TextConsole fConsole;

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset() + 1;
            int length = event.getLength() - 2;
            String text = this.fConsole.getDocument().get(offset, length);
            String textNew = text.replaceAll("\u001b\\[[\\d;]*[A-HJKSTfimnsu]", "");
            int delta = text.indexOf(textNew);
            if (delta != -1) {
                offset += delta;
                length = textNew.length();
            }
            JavaStackTraceHyperlink link = new JavaStackTraceHyperlink(this.fConsole);
            this.fConsole.addHyperlink((IHyperlink)link, offset, length);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

