/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.filediff;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.filediff.AbstractFileDiffHandler;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class FileDiffCompareWorkingTreeHandler
extends AbstractFileDiffHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        List<FileDiff> diffs = this.getDiffs(selection, Predicate.not(FileDiff::isSubmodule));
        if (!diffs.isEmpty()) {
            if (diffs.size() == 1) {
                this.showWorkingDirectoryFileDiff(part, diffs.get(0));
            } else {
                FileDiff first = diffs.get(0);
                Repository repository = first.getRepository();
                IPath workingTree = Path.fromOSString((String)repository.getWorkTree().getAbsolutePath());
                List<IPath> paths = diffs.stream().map(FileDiff::getPath).map(arg_0 -> ((IPath)workingTree).append(arg_0)).collect(Collectors.toList());
                GitCompareEditorInput comparison = new GitCompareEditorInput(null, first.getCommit().name(), repository, paths.toArray(new IPath[0]));
                CompareUtils.openInCompare(part.getSite().getPage(), repository, comparison);
            }
        }
        return null;
    }

    private void showWorkingDirectoryFileDiff(IWorkbenchPart part, FileDiff d) {
        String p = d.getPath();
        RevCommit commit = d.getCommit();
        Repository repo = d.getRepository();
        if (commit == null || repo == null || p == null) {
            Activator.showError(UIText.GitHistoryPage_openFailed, null);
            return;
        }
        IWorkbenchPage activePage = part.getSite().getPage();
        IFile file = ResourceUtil.getFileForLocation((Repository)repo, (String)p, (boolean)false);
        try {
            if (file != null) {
                IResource[] resources = new IResource[]{file};
                CompareUtils.compare(resources, repo, "HEAD", commit.getName(), true, activePage);
            } else {
                IPath path = new Path(repo.getWorkTree().getAbsolutePath()).append(p);
                File ioFile = path.toFile();
                if (ioFile.exists()) {
                    CompareUtils.compare(path, repo, "HEAD", commit.getName(), true, activePage);
                }
            }
        }
        catch (IOException e) {
            Activator.handleError(UIText.GitHistoryPage_openFailed, e, true);
        }
    }
}

