/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryBundleContainer
extends AbstractBundleContainer {
    public static final String ATTRIBUTE_URI = "uri";
    public static final String ELEMENT_REQUIRE = "require";
    public static final String TYPE = "Repository";
    private final String uri;
    private final Collection<Requirement> requirements;

    public RepositoryBundleContainer(String uri, Collection<Requirement> requirements) {
        this.uri = uri;
        this.requirements = requirements;
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        ResourcesRepository repository = this.getRepository(monitor);
        Map providers = repository.findProviders(this.getRequirements());
        ArrayList<TargetBundle> bundles = new ArrayList<TargetBundle>();
        List<ResourceUtils.ContentCapability> contentCapabilities = providers.values().stream().flatMap(Collection::stream).map(Capability::getResource).distinct().map(ResourceUtils::getContentCapability).filter(Objects::nonNull).toList();
        CacheManager cacheManager = this.getCacheManager();
        for (ResourceUtils.ContentCapability content : contentCapabilities) {
            URI url = content.url();
            try {
                File file = cacheManager != null ? cacheManager.createCacheFromFile(url, monitor) : new File(FileLocator.toFileURL((URL)url.toURL()).toURI());
                bundles.add(new TargetBundle(file));
            }
            catch (IOException | URISyntaxException e) {
                throw new CoreException(Status.error((String)("Can't fetch bundle from " + String.valueOf(url)), (Throwable)e));
            }
        }
        return (TargetBundle[])bundles.toArray(TargetBundle[]::new);
    }

    public String getUri() {
        return this.uri;
    }

    public Collection<Requirement> getRequirements() {
        return this.requirements;
    }

    public ResourcesRepository getRepository(IProgressMonitor monitor) throws CoreException {
        String location = this.getLocation(true);
        try {
            URI base = new URI(location);
            try {
                CacheManager cacheManager = this.getCacheManager();
                if (cacheManager != null) {
                    File file = cacheManager.createCacheFromFile(base, monitor);
                    return new ResourcesRepository((Collection)XMLResourceParser.getResources((File)file, (URI)base));
                }
                return new ResourcesRepository((Collection)XMLResourceParser.getResources((URI)base));
            }
            catch (Exception e) {
                if (e instanceof CoreException) {
                    CoreException core = (CoreException)((Object)e);
                    throw core;
                }
                if (e instanceof RuntimeException) {
                    RuntimeException runtime = (RuntimeException)e;
                    throw runtime;
                }
                throw new CoreException(Status.error((String)("Loading repository from " + location + " failed: " + String.valueOf(e)), (Throwable)e));
            }
        }
        catch (URISyntaxException e) {
            throw new CoreException(Status.error((String)("Invalid URI: " + location), (Throwable)e));
        }
    }

    private CacheManager getCacheManager() throws CoreException {
        return (CacheManager)P2TargetUtils.getAgent().getService(CacheManager.class);
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        return new TargetFeature[0];
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        if (resolve) {
            return this.resolveVariables(this.uri);
        }
        return this.uri;
    }

    @Override
    public String serialize() {
        try {
            Document document = XmlProcessorFactory.newDocumentWithErrorOnDOCTYPE();
            Element containerElement = document.createElement("location");
            containerElement.setAttribute("type", TYPE);
            containerElement.setAttribute(ATTRIBUTE_URI, this.getUri());
            for (Requirement requirement : this.requirements) {
                Element requireElement = document.createElement(ELEMENT_REQUIRE);
                requireElement.setTextContent(requirement.toString());
                containerElement.appendChild(requireElement);
            }
            document.appendChild(containerElement);
            StreamResult result = new StreamResult(new StringWriter());
            TransformerFactory f = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE();
            Transformer transformer = f.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), result);
            String xml = result.getWriter().toString();
            return xml;
        }
        catch (Exception e) {
            PDECore.log(e);
            return null;
        }
    }

    public void reload() {
        this.fResolutionStatus = null;
        this.fBundles = null;
    }
}

