/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.osgi.framework.BundleContext;

public final class UMLPlugin
extends EMFPlugin {
    private static final Map<String, UMLUtil.StereotypeApplicationStorage> stereotypeApplicationStorages = new HashMap<String, UMLUtil.StereotypeApplicationStorage>();
    private static Map<String, URI> ePackageNsURIToProfileLocationMap;
    private static Map<String, URI> ePackageNsURIToPackageLocationMap;
    protected static final String STEREOTYPE_APPLICATION_STORAGE_PPID = "stereotype_application_storage";
    protected static final String GENERATED_PACKAGE_PPID = "generated_package";
    protected static final String DYNAMIC_PACKAGE_PPID = "dynamic_package";
    public static final UMLPlugin INSTANCE;
    private static Implementation plugin;

    static {
        INSTANCE = new UMLPlugin();
    }

    public static Map<String, UMLUtil.StereotypeApplicationStorage> getStereotypeApplicationStorages() {
        return stereotypeApplicationStorages;
    }

    public static Map<String, URI> getEPackageNsURIToProfileLocationMap() {
        if (ePackageNsURIToProfileLocationMap == null) {
            ePackageNsURIToProfileLocationMap = new HashMap<String, URI>();
        }
        return ePackageNsURIToProfileLocationMap;
    }

    public static Map<String, URI> getEPackageNsURIToPackageLocationMap() {
        if (ePackageNsURIToPackageLocationMap == null) {
            ePackageNsURIToPackageLocationMap = new HashMap<String, URI>();
        }
        return ePackageNsURIToPackageLocationMap;
    }

    public UMLPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    protected static class DynamicPackageRegistryReader
    extends PackageRegistryReader {
        protected DynamicPackageRegistryReader() {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.DYNAMIC_PACKAGE_PPID);
        }

        protected DynamicPackageRegistryReader(Map<String, URI> ePackageNsURIToProfileLocationMap) {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.DYNAMIC_PACKAGE_PPID, ePackageNsURIToProfileLocationMap, null);
        }
    }

    public static class ExtensionProcessor {
        public static synchronized void process(ClassLoader classLoader) {
            EcorePlugin.ExtensionProcessor.process((ClassLoader)classLoader);
            if (ePackageNsURIToProfileLocationMap == null && !EMFPlugin.IS_ECLIPSE_RUNNING) {
                ePackageNsURIToProfileLocationMap = new HashMap();
                ExtensionProcessor.internalProcessExtensions();
                ExtensionProcessor.mapPlatformPluginURIs();
            }
        }

        private static void internalProcessExtensions() {
            new StereotypeApplicationStorageReader().readRegistry();
            new GeneratedPackageRegistryReader(UMLPlugin.getEPackageNsURIToProfileLocationMap(), UMLPlugin.getEPackageNsURIToPackageLocationMap()).readRegistry();
            new DynamicPackageRegistryReader(UMLPlugin.getEPackageNsURIToProfileLocationMap()).readRegistry();
        }

        private static void mapPlatformPluginURIs() {
            HashSet<URI> umlResourceURIs = new HashSet<URI>();
            umlResourceURIs.add(URIConverter.INSTANCE.normalize(URI.createURI((String)"pathmap://UML_LIBRARIES/")));
            URIConverter.URI_MAP.putAll(EcorePlugin.computePlatformResourceToPlatformPluginMap(umlResourceURIs));
        }
    }

    protected static class GeneratedPackageRegistryReader
    extends PackageRegistryReader {
        protected GeneratedPackageRegistryReader() {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.GENERATED_PACKAGE_PPID);
        }

        protected GeneratedPackageRegistryReader(Map<String, URI> ePackageNsURIToProfileLocationMap, Map<String, URI> ePackageNsURIToPackageLocationMap) {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.GENERATED_PACKAGE_PPID, ePackageNsURIToProfileLocationMap, ePackageNsURIToPackageLocationMap);
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            ExtensionProcessor.internalProcessExtensions();
        }
    }

    protected static class PackageRegistryReader
    extends RegistryReader {
        protected static final String TAG_PROFILE = "profile";
        protected static final String TAG_PACKAGE = "package";
        protected static final String ATT_URI = "uri";
        protected static final String ATT_LOCATION = "location";
        protected Map<String, URI> ePackageNsURIToProfileLocationMap;
        protected Map<String, URI> ePackageNsURIToPackageLocationMap;

        protected PackageRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID) {
            super(pluginRegistry, pluginID, extensionPointID);
        }

        protected PackageRegistryReader(IExtensionRegistry pluginRegistry, String pluginID, String extensionPointID, Map<String, URI> ePackageNsURIToProfileLocationMap, Map<String, URI> ePackageNsURIToPackageLocationMap) {
            this(pluginRegistry, pluginID, extensionPointID);
            this.ePackageNsURIToProfileLocationMap = ePackageNsURIToProfileLocationMap;
            this.ePackageNsURIToPackageLocationMap = ePackageNsURIToPackageLocationMap;
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            String tagName = element.getName();
            if (tagName.equals(TAG_PROFILE) || tagName.equals(TAG_PACKAGE)) {
                Map<String, URI> uriToLocationMap = tagName.equals(TAG_PROFILE) ? this.ePackageNsURIToProfileLocationMap : this.ePackageNsURIToPackageLocationMap;
                String uri = element.getAttribute(ATT_URI);
                if (uri == null) {
                    this.logMissingAttribute(element, ATT_URI);
                } else {
                    if (add) {
                        String location;
                        if (uriToLocationMap != null && (location = element.getAttribute(ATT_LOCATION)) != null) {
                            URI packageLocation = URI.createURI((String)location);
                            if (packageLocation.isRelative()) {
                                packageLocation = URI.createPlatformPluginURI((String)(String.valueOf(element.getDeclaringExtension().getContributor().getName()) + '/' + location), (boolean)false);
                            }
                            uriToLocationMap.put(uri, packageLocation);
                        }
                        return true;
                    }
                    uriToLocationMap.remove(uri);
                    return true;
                }
            }
            return false;
        }
    }

    protected static class StereotypeApplicationStorageReader
    extends RegistryReader {
        protected static final String TAG_STORAGE = "storage";
        protected static final String ATT_ID = "id";
        protected static final String ATT_NAME = "name";
        protected static final String ATT_DESCRIPTION = "description";
        protected static final String ATT_CLASS = "class";

        protected StereotypeApplicationStorageReader() {
            super(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), UMLPlugin.STEREOTYPE_APPLICATION_STORAGE_PPID);
        }

        protected boolean readElement(IConfigurationElement element, boolean add) {
            String tagName = element.getName();
            if (tagName.equals(TAG_STORAGE)) {
                String id = element.getAttribute(ATT_ID);
                if (id == null) {
                    this.logMissingAttribute(element, ATT_ID);
                    return false;
                }
                String class_ = element.getAttribute(ATT_CLASS);
                if (class_ == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                    return false;
                }
                if (add) {
                    DescriptorImpl descriptor = new DescriptorImpl(element);
                    UMLUtil.StereotypeApplicationStorage.Registry.INSTANCE.put(id, descriptor);
                } else {
                    UMLUtil.StereotypeApplicationStorage.Registry.INSTANCE.remove(id);
                }
                return true;
            }
            return false;
        }

        private static final class DescriptorImpl
        extends RegistryReader.PluginClassDescriptor
        implements UMLUtil.StereotypeApplicationStorage.Descriptor {
            public DescriptorImpl(IConfigurationElement element) {
                super(element, StereotypeApplicationStorageReader.ATT_CLASS);
            }

            @Override
            public String getID() {
                return this.element.getAttribute(StereotypeApplicationStorageReader.ATT_ID);
            }

            @Override
            public String getName() {
                return this.element.getAttribute(StereotypeApplicationStorageReader.ATT_NAME);
            }

            @Override
            public String getDescription() {
                return this.element.getAttribute(StereotypeApplicationStorageReader.ATT_DESCRIPTION);
            }

            @Override
            public UMLUtil.StereotypeApplicationStorage getStereotypeApplicationStorage() {
                return (UMLUtil.StereotypeApplicationStorage)this.createInstance();
            }

            public String toString() {
                return this.getID();
            }
        }
    }
}

