/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.part.Messages;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.part.SiriusNewDiagramFileWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private URI domainModelURI;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        IFile file = (IFile)((IStructuredSelection)selection).getFirstElement();
        this.domainModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        action.setEnabled(true);
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(this.domainModelURI);
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain(set);
        EObject diagramRoot = null;
        try {
            Resource resource = set.getResource(this.domainModelURI, true);
            diagramRoot = (EObject)resource.getContents().get(0);
        }
        catch (WrappedException ex) {
            DiagramPlugin.getDefault().logError(MessageFormat.format(org.eclipse.sirius.diagram.ui.provider.Messages.SiriusInitDiagramFileAction_loadResourceError, this.domainModelURI), (Throwable)ex);
        }
        if (diagramRoot == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SiriusInitDiagramFileAction_InitDiagramFileResourceErrorDialogTitle, (String)Messages.SiriusInitDiagramFileAction_InitDiagramFileResourceErrorDialogMessage);
            return;
        }
        SiriusNewDiagramFileWizard wizard = new SiriusNewDiagramFileWizard(this.domainModelURI, diagramRoot, editingDomain);
        wizard.setWindowTitle(MessageFormat.format(Messages.SiriusInitDiagramFileAction_InitDiagramFileWizardTitle, "Sirius"));
        SiriusDiagramEditorUtil.runWizard(this.getShell(), wizard, "InitDiagramFile");
    }
}

