/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;

public class ModelResourceListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    protected final Set<URI> changedURIs = new LinkedHashSet<URI>();
    protected final Set<URI> removedURIs = new LinkedHashSet<URI>();
    protected final ReentrantLock internalLock = new ReentrantLock();

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        this.internalLock.lock();
        try {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
                this.internalLock.unlock();
            }
        }
        finally {
            this.internalLock.unlock();
        }
    }

    public Set<URI> popChangedURIs() {
        ImmutableSet changed;
        this.internalLock.lock();
        try {
            changed = ImmutableSet.copyOf(this.changedURIs);
            this.changedURIs.clear();
        }
        finally {
            this.internalLock.unlock();
        }
        return changed;
    }

    public Set<URI> popRemovedURIs() {
        ImmutableSet removed;
        this.internalLock.lock();
        try {
            removed = ImmutableSet.copyOf(this.removedURIs);
            this.removedURIs.clear();
        }
        finally {
            this.internalLock.unlock();
        }
        return removed;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getFlags() == 131072 || delta.getResource().getType() != 1) {
            return true;
        }
        IFile file = (IFile)delta.getResource();
        URI fileURI = ResourceUtil.createURIFor((IFile)file);
        if (delta.getKind() == 2) {
            this.removedURIs.add(fileURI);
            this.changedURIs.remove(fileURI);
        } else if (ResourceUtil.hasModelType((IFile)file)) {
            if ((delta.getKind() & 4) != 0) {
                this.changedURIs.add(fileURI);
                this.removedURIs.remove(fileURI);
            } else if ((delta.getKind() & 1) != 0 && this.removedURIs.remove(fileURI)) {
                this.changedURIs.add(fileURI);
            }
        }
        return true;
    }
}

