/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.ExceptionHandler;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.IOTimeoutException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class Signal
implements Runnable,
IManagedContainerProvider {
    public static final long NO_TIMEOUT = -1L;
    private static final boolean DISABLE_LOG_EXCEPTIONS = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.signal.Signal.disableLogExceptions");
    private static final boolean SHORT_TO_STRING = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.signal.Signal.shortToString");
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, Signal.class);
    private final SignalProtocol<?> protocol;
    private final short id;
    private String name;
    private int correlationID;
    private BufferInputStream bufferInputStream;
    private BufferOutputStream bufferOutputStream;
    private InputStream wrappedInputStream;
    private OutputStream wrappedOutputStream;
    private Object currentStream;
    long scheduled = -1L;

    public Signal(SignalProtocol<?> protocol, short id, String name) {
        this.protocol = protocol;
        this.id = id;
        this.name = name;
    }

    public Signal(SignalProtocol<?> protocol, short id) {
        this(protocol, id, null);
    }

    public Signal(SignalProtocol<?> protocol, Enum<?> literal) {
        this(protocol, (short)literal.ordinal(), literal.name());
    }

    public SignalProtocol<?> getProtocol() {
        return this.protocol;
    }

    public final short getID() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = ReflectUtil.getSimpleClassName((Object)this);
        }
        return this.name;
    }

    public final int getCorrelationID() {
        return this.correlationID;
    }

    public IManagedContainer getContainer() {
        return ContainerUtil.getContainer(this.protocol);
    }

    public String toString() {
        return this.toString(SHORT_TO_STRING);
    }

    public String toString(boolean shortForm) {
        String name = this.getName();
        String additionalInfo = this.getAdditionalInfo();
        if (StringUtil.isEmpty((String)additionalInfo)) {
            if (shortForm) {
                return name;
            }
            return MessageFormat.format("{0}[protocol={1}, correlation={2}]", name, this.getProtocol().getType(), this.getCorrelationID());
        }
        if (shortForm) {
            return MessageFormat.format("{0}[{1}]", name, additionalInfo);
        }
        return MessageFormat.format("{0}[protocol={1}, correlation={2}, {3}]", name, this.getProtocol().getType(), this.getCorrelationID(), additionalInfo);
    }

    protected String getAdditionalInfo() {
        return "";
    }

    @Override
    public final void run() {
        String threadName = null;
        Thread currentThread = null;
        try {
            try {
                if (OM.SET_SIGNAL_THREAD_NAME) {
                    threadName = this.getClass().getSimpleName();
                    currentThread = Thread.currentThread();
                    ConcurrencyUtil.setThreadName((Thread)currentThread, (String)threadName);
                }
                this.runSync();
            }
            catch (Exception ex) {
                if (DISABLE_LOG_EXCEPTIONS) {
                    if (TRACER.isEnabled()) {
                        TRACER.trace("Exception in signal", (Throwable)ex);
                    }
                } else {
                    try {
                        this.handleRunException(ex);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (threadName != null) {
                    ConcurrencyUtil.setThreadName((Thread)currentThread, (String)(String.valueOf(threadName) + "(FINISHED)"));
                }
            }
        }
        finally {
            if (threadName != null) {
                ConcurrencyUtil.setThreadName((Thread)currentThread, (String)(String.valueOf(threadName) + "(FINISHED)"));
            }
        }
    }

    protected final BufferInputStream getBufferInputStream() {
        return this.bufferInputStream;
    }

    protected final BufferOutputStream getBufferOutputStream() {
        return this.bufferOutputStream;
    }

    protected final void flush() throws IOException {
        if (this.currentStream instanceof OutputStream) {
            ((OutputStream)this.currentStream).flush();
        }
    }

    protected boolean closeChannelAfterMe() {
        return false;
    }

    protected boolean closeInputStreamAfterMe() {
        return true;
    }

    protected boolean closeOutputStreamAfterMe() {
        return true;
    }

    protected InputStream getCurrentInputStream() {
        if (this.currentStream instanceof InputStream) {
            return (InputStream)this.currentStream;
        }
        return null;
    }

    protected OutputStream getCurrentOutputStream() {
        if (this.currentStream instanceof OutputStream) {
            return (OutputStream)this.currentStream;
        }
        return null;
    }

    protected InputStream wrapInputStream(InputStream in) throws IOException {
        this.currentStream = this.getProtocol().wrapInputStream(in);
        return (InputStream)this.currentStream;
    }

    protected OutputStream wrapOutputStream(OutputStream out) throws IOException {
        this.currentStream = this.getProtocol().wrapOutputStream(out);
        return (OutputStream)this.currentStream;
    }

    protected void finishInputStream(InputStream in) throws IOException {
        this.currentStream = null;
        this.protocol.finishInputStream(in);
    }

    protected void finishOutputStream(OutputStream out) throws IOException {
        this.currentStream = null;
        this.protocol.finishOutputStream(out);
    }

    protected void handleRunException(Throwable ex) throws Throwable {
        ExceptionHandler.Factory.handle((IManagedContainerProvider)this, (Throwable)ex, (String)"run() failed", (OMLogger)OM.LOG);
    }

    protected abstract void execute(BufferInputStream var1, BufferOutputStream var2) throws Exception;

    void runSync() throws Exception {
        Exception exception = null;
        try {
            try {
                this.execute(this.bufferInputStream, this.bufferOutputStream);
            }
            catch (IOTimeoutException ex) {
                exception = ex.createTimeoutException();
                throw exception;
            }
            catch (Exception ex) {
                exception = ex;
                throw exception;
            }
        }
        catch (Throwable throwable) {
            if (this.closeInputStreamAfterMe()) {
                IOUtil.closeSilent((Closeable)(this.wrappedInputStream != null ? this.wrappedInputStream : this.bufferInputStream));
            }
            if (this.closeOutputStreamAfterMe()) {
                IOUtil.closeSilent((Closeable)(this.wrappedOutputStream != null ? this.wrappedOutputStream : this.bufferOutputStream));
            }
            this.protocol.stopSignal(this, exception);
            throw throwable;
        }
        if (this.closeInputStreamAfterMe()) {
            IOUtil.closeSilent((Closeable)(this.wrappedInputStream != null ? this.wrappedInputStream : this.bufferInputStream));
        }
        if (this.closeOutputStreamAfterMe()) {
            IOUtil.closeSilent((Closeable)(this.wrappedOutputStream != null ? this.wrappedOutputStream : this.bufferOutputStream));
        }
        this.protocol.stopSignal(this, exception);
    }

    void setCorrelationID(int correlationID) {
        this.correlationID = correlationID;
    }

    void setBufferInputStream(BufferInputStream inputStream) {
        this.bufferInputStream = inputStream;
    }

    void setBufferOutputStream(BufferOutputStream outputStream) {
        this.bufferOutputStream = outputStream;
    }

    void doOutput(BufferOutputStream out) throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("================ {0}: {1}", new Object[]{this.getOutputMeaning(), this});
        }
        this.wrappedOutputStream = this.wrapOutputStream(out);
        ExtendedDataOutputStream extended = ExtendedDataOutputStream.wrap((OutputStream)this.wrappedOutputStream);
        try {
            this.doExtendedOutput(extended);
        }
        finally {
            this.finishOutputStream(this.wrappedOutputStream);
        }
        boolean ccam = this.closeChannelAfterMe();
        out.flushWithEOS(ccam);
    }

    void doInput(BufferInputStream in) throws Exception {
        if (TRACER.isEnabled()) {
            TRACER.format("================ {0}: {1}", new Object[]{this.getInputMeaning(), this});
        }
        this.wrappedInputStream = this.wrapInputStream(in);
        ExtendedDataInputStream extended = ExtendedDataInputStream.wrap((InputStream)this.wrappedInputStream);
        try {
            this.doExtendedInput(extended);
        }
        finally {
            this.finishInputStream(this.wrappedInputStream);
        }
    }

    void doExtendedOutput(ExtendedDataOutputStream out) throws Exception {
    }

    void doExtendedInput(ExtendedDataInputStream in) throws Exception {
    }

    abstract String getOutputMeaning();

    abstract String getInputMeaning();
}

