/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.util;

import org.eclipse.emf.cdo.common.util.CDOFingerPrinter;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.EtypesFactory;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.StringUtil;

public final class LMFingerPrintAnnotation {
    public static final String ANNOTATION_SOURCE = "http://www.eclipse.org/CDO/LM/FingerPrint";
    public static final String ANNOTATION_DETAIL_VALUE = "value";
    public static final String ANNOTATION_DETAIL_COUNT = "count";
    public static final String ANNOTATION_DETAIL_PARAM = "param";

    private LMFingerPrintAnnotation() {
    }

    public static Annotation create() {
        return LMFingerPrintAnnotation.create(null, null, null);
    }

    public static Annotation create(CDOFingerPrinter.FingerPrint fingerPrint) {
        if (fingerPrint == null) {
            return null;
        }
        String value = fingerPrint.getValue();
        String count = Long.toString(fingerPrint.getCount());
        String param = fingerPrint.getParam();
        return LMFingerPrintAnnotation.create(value, count, param);
    }

    public static Annotation create(String value, String count, String param) {
        Annotation annotation = EtypesFactory.eINSTANCE.createAnnotation(ANNOTATION_SOURCE);
        EMap details = annotation.getDetails();
        if (!StringUtil.isEmpty((String)value)) {
            details.put((Object)ANNOTATION_DETAIL_VALUE, (Object)value);
        }
        if (!StringUtil.isEmpty((String)count)) {
            details.put((Object)ANNOTATION_DETAIL_COUNT, (Object)count);
        }
        if (!StringUtil.isEmpty((String)param)) {
            details.put((Object)ANNOTATION_DETAIL_PARAM, (Object)param);
        }
        return annotation;
    }

    public static CDOFingerPrinter.FingerPrint getFingerPrint(EObject object) {
        if (object instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)object;
            Annotation annotation = modelElement.getAnnotation(ANNOTATION_SOURCE);
            return annotation == null ? null : LMFingerPrintAnnotation.getFingerPrint(annotation);
        }
        return null;
    }

    public static CDOFingerPrinter.FingerPrint getFingerPrint(Annotation annotation) {
        if (annotation != null && ANNOTATION_SOURCE.equals(annotation.getSource())) {
            EMap details = annotation.getDetails();
            String value = (String)details.get((Object)ANNOTATION_DETAIL_VALUE);
            long count = LMFingerPrintAnnotation.getCount((EMap<String, String>)details);
            String param = (String)details.get((Object)ANNOTATION_DETAIL_PARAM);
            return new CDOFingerPrinter.FingerPrint(value, count, param);
        }
        return null;
    }

    private static long getCount(EMap<String, String> details) {
        String count = (String)details.get((Object)ANNOTATION_DETAIL_COUNT);
        if (count != null) {
            try {
                return Long.parseLong(count);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }
}

