/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;

public class CollapseFigure
extends RectangleFigure {
    private boolean collapsed = false;
    private IFigure containerFigure = null;
    private static boolean isWinOS = SWT.getPlatform().equals("win32");

    public CollapseFigure() {
    }

    public CollapseFigure(IFigure containerFigure) {
        this.containerFigure = containerFigure;
    }

    protected void fillShape(Graphics graphics) {
        Image img = this.isCollapsed() ? (isWinOS ? DiagramUIPluginImages.get("icons/expand.gif") : DiagramUIPluginImages.get("icons/collapsedEmpty.gif")) : (isWinOS ? DiagramUIPluginImages.get("icons/collapse.gif") : DiagramUIPluginImages.get("icons/expanded.gif"));
        graphics.drawImage(img, this.getBounds().x, this.getBounds().y);
    }

    protected void outlineShape(Graphics graphics) {
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean b) {
        this.collapsed = b;
        this.revalidate();
        this.repaint();
    }

    public boolean isVisible() {
        boolean visibility = super.isVisible();
        if (visibility && this.containerFigure != null) {
            Rectangle containerBounds = this.containerFigure.getClientArea().getCopy();
            this.containerFigure.translateToAbsolute((Translatable)containerBounds);
            this.translateToRelative((Translatable)containerBounds);
            return containerBounds.contains(this.getBounds());
        }
        return visibility;
    }
}

