/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDElementReferenceContent;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.util.DTDVisitor;

public class DTDMetrics {
    protected DTDFile dtdFile;
    protected Hashtable elementReferenceMap;

    public DTDMetrics(DTDFile dtdFile) {
        this.dtdFile = dtdFile;
    }

    public Hashtable getElementReferences() {
        if (this.elementReferenceMap == null) {
            this.elementReferenceMap = new Hashtable();
            new DTDVisitor(){

                @Override
                public void visitDTDElementReferenceContent(DTDElementReferenceContent elementReferenceContent) {
                    DTDElement dtdElement = elementReferenceContent.getReferencedElement();
                    Object visitation = DTDMetrics.this.elementReferenceMap.get(dtdElement);
                    if (visitation == null) {
                        visitation = new Vector();
                        DTDMetrics.this.elementReferenceMap.put(dtdElement, visitation);
                    }
                    ((Vector)visitation).addElement(elementReferenceContent);
                }
            }.visitDTDFile(this.dtdFile);
        }
        return this.elementReferenceMap;
    }

    public int getElementReferenceCount(DTDElement dtdElement) {
        Object elementReferences = this.getElementReferences().get(dtdElement);
        return elementReferences == null ? 0 : ((Vector)elementReferences).size();
    }

    public DTDElement getLeastReferencedElement() {
        DTDElement result = null;
        int lowestReferenceCount = Integer.MAX_VALUE;
        List elements = this.dtdFile.listDTDElement();
        for (DTDElement element : elements) {
            int count = this.getElementReferenceCount(element);
            if (count >= lowestReferenceCount) continue;
            result = element;
            lowestReferenceCount = count;
        }
        return result;
    }

    protected Hashtable getElementReferencesGen() {
        if (this.elementReferenceMap == null) {
            this.elementReferenceMap = new Hashtable();
            new DTDVisitor(){

                @Override
                public void visitDTDElementReferenceContent(DTDElementReferenceContent elementReferenceContent) {
                    DTDElement dtdElement = elementReferenceContent.getReferencedElement();
                    Object visitation = DTDMetrics.this.elementReferenceMap.get(dtdElement);
                    if (visitation == null) {
                        visitation = new Vector();
                        DTDMetrics.this.elementReferenceMap.put(dtdElement, visitation);
                    }
                    ((Vector)visitation).addElement(elementReferenceContent);
                }
            }.visitDTDFile(this.dtdFile);
        }
        return this.elementReferenceMap;
    }

    protected int getElementReferenceCountGen(DTDElement dtdElement) {
        Object elementReferences = this.getElementReferences().get(dtdElement);
        return elementReferences == null ? 0 : ((Vector)elementReferences).size();
    }

    protected DTDElement getLeastReferencedElementGen() {
        DTDElement result = null;
        int lowestReferenceCount = Integer.MAX_VALUE;
        List elements = this.dtdFile.listDTDElement();
        for (DTDElement element : elements) {
            int count = this.getElementReferenceCount(element);
            if (count >= lowestReferenceCount) continue;
            result = element;
            lowestReferenceCount = count;
        }
        return result;
    }
}

