/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerSettingsProvider;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsProvider;

public class DebuggerSettingsProviderRegistry {
    private static Map<String, IDebuggerSettingsProvider> providersMap = null;
    protected static final String PROP_ID = "id";
    protected static final String PROP_DEBUGGER_ID = "debuggerId";
    protected static final String PROP_OVERRIDES = "overrides";
    protected static final String PROP_PROVIDER = "provider";
    public static final String EXTENSION_POINT_ID = PHPDebugPlugin.getDefault().getBundle().getSymbolicName() + ".phpDebuggerSettingsProviders";
    private static DebuggerSettingsProviderRegistry instance;

    public static final synchronized IDebuggerSettingsProvider getProvider(String debuggerId) {
        Map<String, IDebuggerSettingsProvider> providers = DebuggerSettingsProviderRegistry.getProviders();
        return providers.get(debuggerId);
    }

    protected static final Map<String, IDebuggerSettingsProvider> getProviders() {
        if (providersMap == null) {
            providersMap = DebuggerSettingsProviderRegistry.getDefault().readFromExtensionPoint();
        }
        return providersMap;
    }

    protected static DebuggerSettingsProviderRegistry getDefault() {
        if (instance == null) {
            instance = new DebuggerSettingsProviderRegistry();
        }
        return instance;
    }

    protected Map<String, IDebuggerSettingsProvider> readFromExtensionPoint() {
        IConfigurationElement[] configurationElements;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(PROP_ID);
            String overridenProviderId = element.getAttribute(PROP_OVERRIDES);
            String debuggerId = element.getAttribute(PROP_DEBUGGER_ID);
            entries.add(new Entry(element, id, debuggerId, overridenProviderId));
            ++n2;
        }
        return this.fetchProviders(entries);
    }

    protected Object createInstance(IConfigurationElement element, String propertyName, Class instanceClass) throws CoreException {
        Object object = element.createExecutableExtension(propertyName);
        if (!instanceClass.isAssignableFrom(object.getClass())) {
            String message = String.format("Invalid typecast for %s", element.getAttribute(propertyName));
            Status status = new Status(4, PHPDebugPlugin.getDefault().getBundle().getSymbolicName(), message);
            throw new CoreException((IStatus)status);
        }
        return object;
    }

    private Map<String, IDebuggerSettingsProvider> fetchProviders(List<Entry> entries) {
        HashMap<String, IDebuggerSettingsProvider> providers = new HashMap<String, IDebuggerSettingsProvider>();
        ArrayList<Entry> highestLevelEntries = new ArrayList<Entry>();
        for (Entry entry : entries) {
            boolean isHighestLevel = true;
            for (Entry e : entries) {
                if (!entry.id.equals(e.overridenProviderId)) continue;
                isHighestLevel = false;
                break;
            }
            if (!isHighestLevel) continue;
            highestLevelEntries.add(entry);
        }
        for (Entry entry : highestLevelEntries) {
            IDebuggerSettingsProvider provider;
            try {
                provider = (IDebuggerSettingsProvider)this.createInstance(entry.element, PROP_PROVIDER, IDebuggerSettingsProvider.class);
            }
            catch (CoreException e) {
                Logger.logException("Could not instantiate debugger settings provider from extension point data.", e);
                continue;
            }
            if (provider instanceof AbstractDebuggerSettingsProvider) {
                ((AbstractDebuggerSettingsProvider)provider).setId(entry.id);
                ((AbstractDebuggerSettingsProvider)provider).load();
            }
            providers.put(entry.debuggerId, provider);
        }
        return providers;
    }

    private class Entry {
        IConfigurationElement element;
        String id;
        String debuggerId;
        String overridenProviderId;

        public Entry(IConfigurationElement element, String id, String debuggerId, String overridenProviderId) {
            this.element = element;
            this.id = id;
            this.debuggerId = debuggerId;
            this.overridenProviderId = overridenProviderId;
        }
    }
}

