/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

class TransposeMetrics
extends GraphVisitor {
    Transposer t = new Transposer();

    TransposeMetrics() {
    }

    @Override
    public void visit(DirectedGraph g) {
        if (g.getDirection() == 4) {
            return;
        }
        this.t.setEnabled(true);
        g.setDefaultPadding(this.t.t(g.getDefaultPadding()));
        for (Node node : g.nodes) {
            int temp = node.width;
            node.width = node.height;
            node.height = temp;
            if (node.getPadding() == null) continue;
            node.setPadding(this.t.t(node.getPadding()));
        }
    }

    @Override
    public void revisit(DirectedGraph g) {
        int temp;
        if (g.getDirection() == 4) {
            return;
        }
        g.setDefaultPadding(this.t.t(g.getDefaultPadding()));
        for (Node node : g.nodes) {
            temp = node.width;
            node.width = node.height;
            node.height = temp;
            temp = node.y;
            node.y = node.x;
            node.x = temp;
            if (node.getPadding() == null) continue;
            node.setPadding(this.t.t(node.getPadding()));
        }
        for (Edge edge : g.edges) {
            edge.start.transpose();
            edge.end.transpose();
            edge.getPoints().transpose();
            NodeList bends = edge.vNodes;
            if (bends == null) continue;
            for (Node vnode : bends) {
                temp = vnode.y;
                vnode.y = vnode.x;
                vnode.x = temp;
                temp = vnode.width;
                vnode.width = vnode.height;
                vnode.height = temp;
            }
        }
        g.size.transpose();
    }
}

