/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.participants.XMLReferencesErrorCode;
import org.eclipse.lemminx.extensions.references.search.ReferenceLink;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLReferencesDiagnosticParticipant
implements IDiagnosticsParticipant {
    private static final String UNDEFINED_REFERENCE_MESSSAGE = "Undefined reference ''{0}'': nothing that matches the expression ''{1}'' defines ''{2}''.";
    private static final String INVALID_PREFIX_MESSSAGE = "Invalid reference ''{0}'': references to declarations that match the expression ''{1}'' require the ''{2}'' prefix.";
    private final XMLReferencesPlugin plugin;

    public XMLReferencesDiagnosticParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void doDiagnostics(DOMDocument document, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker cancelChecker) {
        Collection<ReferenceLink> links = SearchEngine.getInstance().searchLinks(document, this.plugin.getReferencesSettings(), cancelChecker);
        if (links.isEmpty()) {
            return;
        }
        for (ReferenceLink link : links) {
            for (SearchNode from : link.getFroms()) {
                String value;
                if (document != from.getOwnerDocument()) continue;
                if (!from.isValid()) {
                    if (from.getValidationStatus() != SearchNode.ValidationStatus.INVALID_PREFIX) continue;
                    Range range = XMLPositionUtility.createRange(from);
                    String message = MessageFormat.format(INVALID_PREFIX_MESSSAGE, from.getValue(null), link.getExpression().getTo(), link.getExpression().getPrefix());
                    Diagnostic diagnostic = new Diagnostic(range, message, DiagnosticSeverity.Warning, "xml", XMLReferencesErrorCode.InvalidPrefix.getCode());
                    diagnostics.add(diagnostic);
                    continue;
                }
                boolean validReference = false;
                for (SearchNode to : link.getTos()) {
                    if (!from.matchesValue(to)) continue;
                    validReference = true;
                    break;
                }
                if (validReference) continue;
                Range range = XMLPositionUtility.createRange(from);
                String valueWithoutPrefix = value = from.getValue(null);
                if (from.getPrefix() != null) {
                    valueWithoutPrefix = value.substring(from.getPrefix().length(), value.length());
                }
                String message = MessageFormat.format(UNDEFINED_REFERENCE_MESSSAGE, value, link.getExpression().getTo(), valueWithoutPrefix);
                Diagnostic diagnostic = new Diagnostic(range, message, DiagnosticSeverity.Warning, "xml", XMLReferencesErrorCode.UndefinedReference.getCode());
                diagnostics.add(diagnostic);
            }
        }
    }
}

