/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.junit.ui.AddAnnotationProposal;
import org.eclipse.jdt.internal.junit.ui.RemoveAnnotationProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;

public class JUnitQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final String JUNIT4_IGNORE_ANNOTATION = "org.junit.Ignore";
    private static final String JUNIT5_DISABLED_ANNOTATION = "org.junit.jupiter.api.Disabled";
    private static final String JUNIT5_TEST_ANNOTATION = "org.junit.jupiter.api.Test";
    private static final String JUNIT5_PARAMETERIZED_TEST_ANNOTATION = "org.junit.jupiter.params.ParameterizedTest";
    private static final String JUNIT5_REPEATED_TEST_ANNOTATION = "org.junit.jupiter.api.RepeatedTest";
    private static final String JUNIT5_TEST_FACTORY_ANNOTATION = "org.junit.jupiter.api.TestFactory";
    private static final String JUNIT5_TEST_TEMPLATE_ANNOTATION = "org.junit.jupiter.api.TestTemplate";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode == null) {
            return false;
        }
        MethodDeclaration methodDecl = this.getMethodDeclaration(coveringNode);
        if (methodDecl == null) {
            return false;
        }
        return this.isJUnitTestMethod(methodDecl);
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode == null) {
            return null;
        }
        MethodDeclaration methodDecl = this.getMethodDeclaration(coveringNode);
        if (methodDecl == null) {
            return null;
        }
        if (!this.isJUnitTestMethod(methodDecl)) {
            return null;
        }
        ArrayList<Object> proposals = new ArrayList<Object>();
        boolean hasDisabledAnnotation = this.hasAnnotation(methodDecl, JUNIT5_DISABLED_ANNOTATION);
        boolean hasIgnoreAnnotation = this.hasAnnotation(methodDecl, JUNIT4_IGNORE_ANNOTATION);
        if (hasDisabledAnnotation || hasIgnoreAnnotation) {
            String annotationToRemove = hasDisabledAnnotation ? JUNIT5_DISABLED_ANNOTATION : JUNIT4_IGNORE_ANNOTATION;
            proposals.add(new RemoveAnnotationProposal(context, methodDecl, annotationToRemove));
        } else if (this.isJUnit5TestMethod(methodDecl)) {
            proposals.add(new AddAnnotationProposal(context, methodDecl, JUNIT5_DISABLED_ANNOTATION, "Disabled"));
        } else if (this.hasAnnotation(methodDecl, "org.junit.Test")) {
            proposals.add(new AddAnnotationProposal(context, methodDecl, JUNIT4_IGNORE_ANNOTATION, "Ignore"));
        }
        if (proposals.isEmpty()) {
            return null;
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    private MethodDeclaration getMethodDeclaration(ASTNode node) {
        while (node != null && !(node instanceof MethodDeclaration)) {
            node = node.getParent();
        }
        return (MethodDeclaration)node;
    }

    private boolean isJUnitTestMethod(MethodDeclaration methodDecl) {
        IAnnotationBinding[] annotations;
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifiedName;
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = annotation.getAnnotationType();
            if (annotationType != null && ("org.junit.Test".equals(qualifiedName = annotationType.getQualifiedName()) || this.isJUnit5TestAnnotation(qualifiedName))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isJUnit5TestMethod(MethodDeclaration methodDecl) {
        IAnnotationBinding[] annotations;
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifiedName;
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = annotation.getAnnotationType();
            if (annotationType != null && this.isJUnit5TestAnnotation(qualifiedName = annotationType.getQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isJUnit5TestAnnotation(String qualifiedName) {
        return JUNIT5_TEST_ANNOTATION.equals(qualifiedName) || JUNIT5_PARAMETERIZED_TEST_ANNOTATION.equals(qualifiedName) || JUNIT5_REPEATED_TEST_ANNOTATION.equals(qualifiedName) || JUNIT5_TEST_FACTORY_ANNOTATION.equals(qualifiedName) || JUNIT5_TEST_TEMPLATE_ANNOTATION.equals(qualifiedName);
    }

    private boolean hasAnnotation(MethodDeclaration methodDecl, String annotationQualifiedName) {
        IAnnotationBinding[] annotations;
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding == null) {
            return false;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotations = binding.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = annotation.getAnnotationType();
            if (annotationType != null && annotationQualifiedName.equals(annotationType.getQualifiedName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

