/*
 * Decompiled with CFR 0.152.
 */
package transparentruler;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Ruler
extends JFrame {
    private static final Color BACKGROUND = Color.RED;
    private static final Color FOREGROUND = Color.WHITE;
    private static final int OPACITY = 180;
    private static final int W = 70;
    private static final int F_HEIGHT = 400;
    private static final int F_WIDTH = 647;
    private static boolean translucencySupported;
    private static boolean transparencySupported;
    private final ComponentAdapter componentListener = new ComponentAdapter(this){
        final /* synthetic */ Ruler this$0;
        {
            Ruler ruler = this$0;
            Objects.requireNonNull(ruler);
            this.this$0 = ruler;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (transparencySupported) {
                this.this$0.setShape(this.this$0.buildShape());
            }
        }
    };
    private final Action exitAction = new AbstractAction(this, "Exit"){
        final /* synthetic */ Ruler this$0;
        {
            Ruler ruler = this$0;
            Objects.requireNonNull(ruler);
            this.this$0 = ruler;
            super(arg0);
            this.putValue("MnemonicKey", 88);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    };
    private final JPopupMenu jPopupMenu = new JPopupMenu();
    private final MouseAdapter mouseListener;
    private final KeyAdapter keyboardListener;

    private static boolean checkTranslucencyMode(GraphicsDevice.WindowTranslucency arg) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.isWindowTranslucencySupported(arg);
    }

    public Shape buildShape() {
        int h = this.getHeight();
        int w = this.getWidth();
        float a = (float)Math.hypot(h, w);
        Path2D.Float path = new Path2D.Float();
        path.moveTo(0.0f, 0.0f);
        path.lineTo(w, 0.0f);
        path.lineTo(0.0f, h);
        path.closePath();
        path.moveTo(70.0f, 70.0f);
        path.lineTo(70.0f, (float)h - 70.0f * (a + (float)h) / (float)w);
        path.lineTo((float)w - 70.0f * (a + (float)w) / (float)h, 70.0f);
        path.closePath();
        return path;
    }

    public Ruler() {
        this.jPopupMenu.add(new JMenuItem(this.exitAction));
        this.jPopupMenu.setLightWeightPopupEnabled(false);
        this.mouseListener = new MouseAdapter(this){
            int x;
            int y;
            final /* synthetic */ Ruler this$0;
            {
                Ruler ruler = this$0;
                Objects.requireNonNull(ruler);
                this.this$0 = ruler;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    this.x = e.getX();
                    this.y = e.getY();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if ((e.getModifiersEx() & 0x400) != 0) {
                    this.this$0.setLocation(e.getXOnScreen() - this.x, e.getYOnScreen() - this.y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.this$0.jPopupMenu.show(this.this$0.getContentPane(), e.getX(), e.getY());
                }
            }
        };
        this.keyboardListener = new KeyAdapter(this){
            final /* synthetic */ Ruler this$0;
            {
                Ruler ruler = this$0;
                Objects.requireNonNull(ruler);
                this.this$0 = ruler;
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int step = e.isControlDown() ? 50 : (e.isAltDown() ? 1 : 5);
                switch (e.getKeyCode()) {
                    case 37: {
                        this.this$0.setLocation(this.this$0.getX() - step, this.this$0.getY());
                        break;
                    }
                    case 39: {
                        this.this$0.setLocation(this.this$0.getX() + step, this.this$0.getY());
                        break;
                    }
                    case 38: {
                        this.this$0.setLocation(this.this$0.getX(), this.this$0.getY() - step);
                        break;
                    }
                    case 40: {
                        this.this$0.setLocation(this.this$0.getX(), this.this$0.getY() + step);
                        break;
                    }
                    case 27: {
                        this.this$0.exitAction.actionPerformed(null);
                    }
                }
            }
        };
        this.setUndecorated(true);
        this.setBackground(new Color(BACKGROUND.getRed(), BACKGROUND.getGreen(), BACKGROUND.getBlue(), 180));
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.addComponentListener(this.componentListener);
        this.addKeyListener(this.keyboardListener);
        this.setContentPane(new JPanel(this){
            final /* synthetic */ Ruler this$0;
            {
                Ruler ruler = this$0;
                Objects.requireNonNull(ruler);
                this.this$0 = ruler;
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D gg = (Graphics2D)g.create();
                int w = this.getWidth();
                int h = this.getHeight();
                int hh = gg.getFontMetrics().getAscent();
                if (!transparencySupported) {
                    gg.setBackground(new Color(0, 0, 0, 0));
                    gg.clearRect(0, 0, w, h);
                    gg.clip(this.this$0.buildShape());
                    gg.setBackground(this.this$0.getBackground());
                    gg.clearRect(0, 0, w, h);
                }
                gg.setColor(FOREGROUND);
                for (int x = 0; x < w * (h - 8) / h - 5; x += 5) {
                    boolean hi;
                    boolean bl = hi = x % 50 == 0;
                    gg.drawLine(x + 5, 0, x + 5, hi ? 20 : (x % 25 == 0 ? 13 : 8));
                    if (!hi) continue;
                    String number = Integer.toString(x);
                    int ww = gg.getFontMetrics().stringWidth(number);
                    gg.drawString(number, x + 5 - ww / 2, 20 + hh);
                }
                gg.dispose();
            }
        });
        this.setDefaultCloseOperation(3);
        this.setSize(647, 400);
        this.setLocationByPlatform(true);
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                translucencySupported = Ruler.checkTranslucencyMode(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT);
                transparencySupported = Ruler.checkTranslucencyMode(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
                if (!translucencySupported) {
                    System.err.println("This application requires 'PERPIXEL_TRANSLUCENT' translucency mode to be supported.");
                    System.exit(-1);
                }
                Ruler ruler = new Ruler();
                ruler.setVisible(true);
            }
        });
    }
}

