/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jdk.test.lib.net.URIBuilder;

public class SimpleHttpServer {
    private final HttpServer httpServer;
    private ExecutorService executor;
    private String address;
    private final String context;
    private final String docRoot;
    private final InetSocketAddress inetSocketAddress;

    public SimpleHttpServer(InetSocketAddress inetSocketAddress, String context, String docRoot) throws IOException {
        this.inetSocketAddress = inetSocketAddress;
        this.context = context;
        this.docRoot = docRoot;
        this.httpServer = HttpServer.create();
    }

    public void start() throws IOException, URISyntaxException {
        MyHttpHandler handler = new MyHttpHandler(this, this.docRoot);
        this.httpServer.bind(this.inetSocketAddress, 0);
        this.httpServer.createContext(this.context, handler);
        this.executor = Executors.newCachedThreadPool();
        this.httpServer.setExecutor(this.executor);
        this.httpServer.start();
        this.address = "http:" + URIBuilder.newBuilder().host(this.httpServer.getAddress().getAddress()).port(this.httpServer.getAddress().getPort()).build().toString();
    }

    public void stop() {
        this.httpServer.stop(0);
        this.executor.shutdown();
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.httpServer.getAddress().getPort();
    }

    class MyHttpHandler
    implements HttpHandler {
        private final URI rootUri;

        MyHttpHandler(SimpleHttpServer this$0, String docroot) {
            Objects.requireNonNull(this$0);
            this.rootUri = Path.of(docroot, new String[0]).toUri().normalize();
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            InputStream is = t.getRequestBody();
            try {
                is.readAllBytes();
                Headers rMap = t.getResponseHeaders();
                OutputStream os = t.getResponseBody();
                try {
                    Path fPath;
                    URI uri = t.getRequestURI();
                    String path = uri.getRawPath();
                    assert (path.isEmpty() || path.startsWith("/"));
                    try {
                        uri = URI.create("file://" + this.rootUri.getRawPath() + path).normalize();
                        fPath = Path.of(uri);
                    }
                    catch (IllegalArgumentException | FileSystemNotFoundException ex) {
                        ex.printStackTrace();
                        this.notfound(t, path);
                        if (os != null) {
                            os.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        return;
                    }
                    byte[] bytes = Files.readAllBytes(fPath);
                    String method = t.getRequestMethod();
                    if (method.equals("HEAD")) {
                        rMap.set("Content-Length", Long.toString(bytes.length));
                        t.sendResponseHeaders(200, -1L);
                        t.close();
                    } else if (!method.equals("GET")) {
                        t.sendResponseHeaders(405, -1L);
                        t.close();
                        return;
                    }
                    if (path.endsWith(".html") || path.endsWith(".htm")) {
                        rMap.set("Content-Type", "text/html");
                    } else {
                        rMap.set("Content-Type", "text/plain");
                    }
                    t.sendResponseHeaders(200, bytes.length);
                    os.write(bytes);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }

        void moved(HttpExchange t) throws IOException {
            Headers req = t.getRequestHeaders();
            Headers map = t.getResponseHeaders();
            URI uri = t.getRequestURI();
            String host = req.getFirst("Host");
            String location = "http://" + host + uri.getPath() + "/";
            map.set("Content-Type", "text/html");
            map.set("Location", location);
            t.sendResponseHeaders(301, -1L);
            t.close();
        }

        void notfound(HttpExchange t, String p) throws IOException {
            t.getResponseHeaders().set("Content-Type", "text/html");
            t.sendResponseHeaders(404, 0L);
            try (OutputStream os = t.getResponseBody();){
                Object s = "<h2>File not found</h2>";
                s = (String)s + p + "<p>";
                os.write(((String)s).getBytes());
            }
            t.close();
        }
    }
}

