/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sw_KE extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Cook = new String[] {
               "Saa za Wastani za Visiwa vya Cook",
               "",
               "Saa za Majira Nusu ya Joto za Visiwa vya Cook",
               "",
               "Saa za Visiwa vya Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Saa za Wastani za Kuba",
               "CST",
               "Saa za Mchana za Kuba",
               "CDT",
               "Saa za Kuba",
               "CT",
            };
        final String[] Gulf = new String[] {
               "Saa za Wastani za Ghuba",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Saa za Wastani za Hovd",
               "",
               "Saa za Majira ya Joto za Hovd",
               "",
               "Saa za Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Saa za Wastani za Irani",
               "",
               "Saa za Mchana za Irani",
               "",
               "Saa za Irani",
               "",
            };
        final String[] Omsk = new String[] {
               "Saa za Wastani za Omsk",
               "",
               "Saa za Majira ya Joto za Omsk",
               "",
               "Saa za Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Saa za Wastani za Peru",
               "",
               "Saa za Majira ya Joto za Peru",
               "",
               "Saa za Peru",
               "",
            };
        final String[] Japan = new String[] {
               "Saa za Wastani za Japani",
               "JST",
               "Saa za Mchana za Japani",
               "JDT",
               "Saa za Japani",
               "JT",
            };
        final String[] Nepal = new String[] {
               "Saa za Nepali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Saa za Wastani za Samoa",
               "SST",
               "Saa za Mchana za Samoa",
               "SST",
               "Saa za Samoa",
               "SST",
            };
        final String[] Tonga = new String[] {
               "Saa za Wastani za Tonga",
               "",
               "Saa za Majira ya Joto za Tonga",
               "",
               "Saa za Tonga",
               "",
            };
        final String[] Amazon = new String[] {
               "Saa za Wastani za Amazon",
               "",
               "Saa za Majira ya Joto za Amazon",
               "",
               "Saa za Amazon",
               "",
            };
        final String[] Azores = new String[] {
               "Saa za Wastani za Azores",
               "",
               "Saa za Majira ya Joto za Azores",
               "",
               "Saa za Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Saa za Butani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Saa za Wastani za Kisiwa cha Easter",
               "",
               "Saa za Majira ya Joto za Kisiwa cha Easter",
               "",
               "Saa za Kisiwa cha Easter",
               "",
            };
        final String[] Moscow = new String[] {
               "Saa za Wastani za Moscow",
               "MSK",
               "Saa za Majira ya Joto za Moscow",
               "MSK",
               "Saa za Moscow",
               "MSK",
            };
        final String[] Armenia = new String[] {
               "Saa za Wastani za Armenia",
               "",
               "Saa za Majira ya Joto za Armenia",
               "",
               "Saa za Armenia",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Saa ya Dunia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Saa za Wastani za Jiojia",
               "",
               "Saa za Majira ya Joto za Jiojia",
               "",
               "Saa za Jiojia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Saa za Wastani za Irkutsk",
               "",
               "Saa za Majira ya Joto za Irkutsk",
               "",
               "Saa za Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Saa za Wastani za Magadan",
               "",
               "Saa za Majira ya Joto za Magadan",
               "",
               "Saa za Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Saa za Myanma",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Saa za Wastani za Kisiwa cha Norfolk",
               "",
               "Saa za Majira ya Joto za Kisiwa cha Norfolk",
               "",
               "Saa za Kisiwa cha Norfolk",
               "",
            };
        final String[] Uruguay = new String[] {
               "Saa za Wastani za Urugwai",
               "",
               "Saa za Majira ya Joto za Urugwai",
               "",
               "Saa za Urugwai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Saa za Wastani za Vanuatu",
               "",
               "Saa za Majira ya Joto za Vanuatu",
               "",
               "Saa za Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Saa za Wastani za Yakutsk",
               "",
               "Saa za Majira ya Joto za Yakutsk",
               "",
               "Saa za Yakutsk",
               "",
            };
        final String[] Brasilia = new String[] {
               "Saa za Wastani za Brazili",
               "",
               "Saa za Majira ya Joto za Brazili",
               "",
               "Saa za Brazili",
               "",
            };
        final String[] Colombia = new String[] {
               "Saa za Wastani za Kolombia",
               "",
               "Saa za Majira ya Joto za Kolombia",
               "",
               "Saa za Kolombia",
               "",
            };
        final String[] Malaysia = new String[] {
               "Saa za Malesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Saa za Maldivi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Saa za Wastani za Ulaanbataar",
               "",
               "Saa za Majira ya Joto za Ulaanbaatar",
               "",
               "Saa za Ulaanbataar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Saa za Wastani za Pakistani",
               "PKT",
               "Saa za Majira ya Joto za Pakistani",
               "PKST",
               "Saa za Pakistani",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Saa za Wastani za Paragwai",
               "",
               "Saa za Majira ya Joto za Paragwai",
               "",
               "Saa za Paragwai",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Saa za Wastani za Sakhalin",
               "",
               "Saa za Majira ya Joto za Sakhalin",
               "",
               "Saa za Sakhalin",
               "",
            };
        final String[] Argentina = new String[] {
               "Saa za Wastani za Ajentina",
               "",
               "Saa za Majira Joto za Ajentina",
               "",
               "Saa za Ajentina",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Saa za Wastani za Hong Kong",
               "HKT",
               "Saa za Majira ya Joto za Hong Kong",
               "HKST",
               "Saa za Hong Kong",
               "HKT",
            };
        final String[] Mauritius = new String[] {
               "Saa za Wastani za Morisi",
               "",
               "Saa za Majira ya Joto za Morisi",
               "",
               "Saa za Morisi",
               "",
            };
        final String[] Singapore = new String[] {
               "Saa za Wastani za Singapoo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Saa za Wastani za Volgograd",
               "MSK",
               "Saa za Majira ya Joto za Volgograd",
               "MSK",
               "Saa za Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Saa za Wastani za Azabajani",
               "",
               "Saa za Majira ya Joto za Azabajani",
               "",
               "Saa za Azabajani",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Saa za Wastani za Bangladeshi",
               "",
               "Saa za Majira ya Joto za Bangladeshi",
               "",
               "Saa za Bangladeshi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Saa za Wastani za Kepuvede",
               "",
               "Saa za Majira ya Joto za Kepuvede",
               "",
               "Saa za Kepuvede",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Saaza Tajikistani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Saa za wastani za Uzbekistani",
               "",
               "Saa za Majira ya Joto za Uzbekistani",
               "",
               "Saa za Uzbekistani",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Saa za Afghanistani",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saa za Wastani za Krasnoyask",
               "",
               "Saa za Majira ya Joto za Krasnoyarsk",
               "",
               "Saa za Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Saa za Wastani za Nyuzilandi",
               "NZST",
               "Saa za Mchana za Nyuzilandi",
               "NZDT",
               "Saa za Nyuzilandi",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Saa za Wastani za Novosibirsk",
               "",
               "Saa za Majira ya Joto za Novosibirsk",
               "",
               "Saa za Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Saa za Wastani za Ufilipino",
               "PST",
               "Saa za Majira ya Joto za Ufilipino",
               "PDT",
               "Saa za Ufilipino",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Saa za Wastani za Vladivostok",
               "",
               "Saa za Majira ya Joto za Vladivostok",
               "",
               "Saa za Vladivostok",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Saa za Wastani za Turkmenistani",
               "",
               "Saa za Majira ya Joto za Turkmenistani",
               "",
               "Saa za Turkmenistani",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Saa za Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Saa za Wastani za Kaledonia Mpya",
               "",
               "Saa za Majira ya Joto za Kaledonia Mpya",
               "",
               "Saa za Kaledonia Mpya",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Saa za Jojia Kusini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Saa za Wastani za Yekaterinburg",
               "",
               "Saa za Majira ya Joto za Yekaterinburg",
               "",
               "Saa za Yekaterinburg",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Saa za Wastani za Afrika Magharibi",
               "WAT",
               "Saa za Majira ya Joto za Afrika Magharibi",
               "WAT",
               "Saa za Afrika Magharibi",
               "WAT",
            };
        final String[] Europe_Central = new String[] {
               "Saa za Wastani za Ulaya ya Kati",
               "CET",
               "Saa za Majira ya Joto za Ulaya ya Kati",
               "CEST",
               "Saa za Ulaya ya Kati",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Saa za Wastani za Mashariki mwa Ulaya",
               "EET",
               "Saa za Majira ya Joto za Mashariki mwa Ulaya",
               "EEST",
               "Saa za Mashariki mwa Ulaya",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Saa za Wastani za Magharibi mwa Ulaya",
               "WET",
               "Saa za Majira ya Joto za Magharibi mwa Ulaya",
               "WEST",
               "Saa za Magharibi mwa Ulaya",
               "WET",
            };
        final String[] Phoenix_Islands = new String[] {
               "Saa za Visiwa vya Finiksi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Saa za Papua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saa za Wastani za Magharibi mwa Australia ya Kati",
               "",
               "Saa za Mchana za Magharibi mwa Australia ya Kati",
               "",
               "Saa za Magharibi mwa Austrialia ya Kati",
               "",
            };
        final Object[][] data = new Object[][] {
            { "Europe/Paris", Europe_Central },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC", ETC_UTC },
            { "NZ", New_Zealand },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CET", Europe_Central },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "UCT",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Poland", Europe_Central },
            { "Etc/UCT",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "Etc/Zulu",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Singapore", Singapore },
            { "Universal",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Malaysia },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Myanmar },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Pacific/Yap", Papua_New_Guinea },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Lima", Peru },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Douala", Africa_Western },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Niamey", Africa_Western },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Etc/Universal",
                new String[] {
                    "Saa ya Dunia",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Samoa", Samoa },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Bogota", Colombia },
            { "America/Cuiaba", Amazon },
            { "America/Havana", Cuba },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Recife", Brasilia },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Atlantic/Faroe", Europe_Western },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Reunion", Gulf },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Mendoza", Argentina },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Norfolk", Norfolk },
            { "America/Asuncion", Paraguay },
            { "America/Santarem", Brasilia },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Madeira", Europe_Western },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Kerguelen", Maldives },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Fortaleza", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Montevideo", Uruguay },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Chile/EasterIsland", Easter },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Porto_Velho", Amazon },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/South_Pole", New_Zealand },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/Catamarca", Argentina },
            { "timezone.excity.Asia/Saigon", "Jiji la Ho Chi Minh" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Rangoon", "Yangon" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Asia/Singapore", "Singapoo" },
            { "timezone.excity.America/Curacao", "kurakao" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
            { "timezone.excity.America/Barbados", "Babados" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.Indian/Christmas", "Krismasi" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/El_Salvador", "Elsalvado" },
            { "timezone.excity.America/Puerto_Rico", "Pwetoriko" },
            { "timezone.excity.America/Port_of_Spain", "Bandari ya Uhispania" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota Kaskazini" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota Kaskazini" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota Kaskazini" },
        };
        return data;
    }
}
