/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.List;
import jdk.test.lib.Asserts;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.parser.Reader;

public class HprofParser {
    public static void main(String[] args) throws Exception {
        File dump;
        if (args.length < 1) {
            System.out.println("No arguments supplied");
        }
        if (!(dump = new File(args[0])).exists() || !dump.isFile()) {
            throw new RuntimeException("The dump file does not exist or not a file");
        }
        HprofParser.parse(dump);
    }

    public static File parseAndVerify(File dump) throws Exception {
        return HprofParser.parse(dump, false, true, true, true);
    }

    public static File parse(File dump) throws Exception {
        return HprofParser.parse(dump, false, true, true, false);
    }

    public static File parseWithDebugInfo(File dump) throws Exception {
        return HprofParser.parse(dump, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File parse(File dump, boolean debug, boolean callStack, boolean calculateRefs, boolean verifyParse) throws Exception {
        File out = new File("hprof." + System.currentTimeMillis() + ".out");
        if (out.exists()) {
            out.delete();
        }
        PrintStream psSystemOut = System.out;
        try (PrintStream psHprof = new PrintStream(new BufferedOutputStream(new FileOutputStream(out.getAbsolutePath())));){
            System.setOut(psHprof);
            int debugLevel = debug ? 2 : 0;
            try (Snapshot snapshot = Reader.readFile(dump.getAbsolutePath(), callStack, debugLevel);){
                System.out.println("Snapshot read, resolving...");
                snapshot.resolve(calculateRefs);
                System.out.println("Snapshot resolved.");
            }
        }
        finally {
            System.setOut(psSystemOut);
        }
        if (verifyParse) {
            HprofParser.verifyParse(out);
        }
        return out;
    }

    private static void verifyParse(File out) throws IOException {
        Asserts.assertTrue(out != null && out.exists() && out.isFile(), "Could not find hprof parser output file");
        List<String> lines = Files.readAllLines(out.toPath());
        Asserts.assertTrue(lines.size() > 0, "hprof parser output file is empty");
        for (String line : lines) {
            Asserts.assertFalse(line.matches(".*WARNING(?!.*Failed to resolve object.*constantPoolOop.*).*"));
        }
    }
}

