/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BasicTextFieldUI
extends BasicTextUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTextFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "TextField";
    }

    @Override
    public View create(Element element) {
        String string;
        Document document = element.getDocument();
        Object object = document.getProperty("i18n");
        if (Boolean.TRUE.equals(object) && (string = element.getName()) != null) {
            if (string.equals("content")) {
                return new GlyphView(element){

                    @Override
                    public float getMinimumSpan(int n) {
                        return this.getPreferredSpan(n);
                    }
                };
            }
            if (string.equals("paragraph")) {
                return new I18nFieldView(element);
            }
        }
        return new FieldView(element);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        View view = this.getRootView((JTextComponent)jComponent);
        if (view.getViewCount() > 0) {
            Insets insets = jComponent.getInsets();
            if ((n2 = n2 - insets.top - insets.bottom) > 0) {
                int n3;
                int n4 = insets.top;
                View view2 = view.getView(0);
                int n5 = (int)view2.getPreferredSpan(1);
                if (n2 != n5) {
                    n3 = n2 - n5;
                    n4 += n3 / 2;
                }
                if (view2 instanceof I18nFieldView) {
                    n3 = BasicHTML.getBaseline(view2, n - insets.left - insets.right, n2);
                    if (n3 < 0) {
                        return -1;
                    }
                    n4 += n3;
                } else {
                    FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
                    n4 += fontMetrics.getAscent();
                }
                return n4;
            }
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.CENTER_OFFSET;
    }

    static class I18nFieldView
    extends ParagraphView {
        I18nFieldView(Element element) {
            super(element);
        }

        @Override
        public int getFlowSpan(int n) {
            return Integer.MAX_VALUE;
        }

        @Override
        protected void setJustification(int n) {
        }

        static boolean isLeftToRight(Component component) {
            return component.getComponentOrientation().isLeftToRight();
        }

        Shape adjustAllocation(Shape shape) {
            if (shape != null) {
                Container container;
                Rectangle rectangle = shape.getBounds();
                int n = (int)this.getPreferredSpan(1);
                int n2 = (int)this.getPreferredSpan(0);
                if (rectangle.height != n) {
                    int n3 = rectangle.height - n;
                    rectangle.y += n3 / 2;
                    rectangle.height -= n3;
                }
                if ((container = this.getContainer()) instanceof JTextField) {
                    int n4;
                    JTextField jTextField = (JTextField)container;
                    BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                    int n5 = Math.max(n2, rectangle.width);
                    int n6 = boundedRangeModel.getValue();
                    if (n6 + (n4 = Math.min(n5, rectangle.width - 1)) > n5) {
                        n6 = n5 - n4;
                    }
                    boundedRangeModel.setRangeProperties(n6, n4, boundedRangeModel.getMinimum(), n5, false);
                    if (n2 < rectangle.width) {
                        int n7 = rectangle.width - 1 - n2;
                        int n8 = ((JTextField)container).getHorizontalAlignment();
                        if (I18nFieldView.isLeftToRight(container)) {
                            if (n8 == 10) {
                                n8 = 2;
                            } else if (n8 == 11) {
                                n8 = 4;
                            }
                        } else if (n8 == 10) {
                            n8 = 4;
                        } else if (n8 == 11) {
                            n8 = 2;
                        }
                        switch (n8) {
                            case 0: {
                                rectangle.x += n7 / 2;
                                rectangle.width -= n7;
                                break;
                            }
                            case 4: {
                                rectangle.x += n7;
                                rectangle.width -= n7;
                            }
                        }
                    } else {
                        rectangle.width = n2;
                        rectangle.x -= boundedRangeModel.getValue();
                    }
                }
                return rectangle;
            }
            return null;
        }

        void updateVisibilityModel() {
            Container container = this.getContainer();
            if (container instanceof JTextField) {
                JTextField jTextField = (JTextField)container;
                BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                int n = (int)this.getPreferredSpan(0);
                int n2 = boundedRangeModel.getExtent();
                int n3 = Math.max(n, n2);
                n2 = n2 == 0 ? n3 : n2;
                int n4 = n3 - n2;
                int n5 = boundedRangeModel.getValue();
                if (n5 + n2 > n3) {
                    n5 = n3 - n2;
                }
                n4 = Math.max(0, Math.min(n4, n5));
                boundedRangeModel.setRangeProperties(n4, n2, 0, n3, false);
            }
        }

        @Override
        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = (Rectangle)shape;
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            super.paint(graphics, this.adjustAllocation(shape));
        }

        @Override
        public int getResizeWeight(int n) {
            if (n == 0) {
                return 1;
            }
            return 0;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return super.modelToView(n, this.adjustAllocation(shape), bias);
        }

        @Override
        public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
            return super.modelToView(n, bias, n2, bias2, this.adjustAllocation(shape));
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return super.viewToModel(f, f2, this.adjustAllocation(shape), biasArray);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.insertUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
            this.updateVisibilityModel();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            super.removeUpdate(documentEvent, this.adjustAllocation(shape), viewFactory);
            this.updateVisibilityModel();
        }
    }
}

