/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

class ServerConfig {
    private static final int DEFAULT_IDLE_TIMER_SCHEDULE_MILLIS = 10000;
    private static final long DEFAULT_IDLE_INTERVAL_IN_SECS = 30L;
    private static final int DEFAULT_MAX_CONNECTIONS = -1;
    private static final int DEFAULT_MAX_IDLE_CONNECTIONS = 200;
    private static final long DEFAULT_MAX_REQ_TIME = -1L;
    private static final long DEFAULT_MAX_RSP_TIME = -1L;
    private static final long DEFAULT_REQ_RSP_TIMER_TASK_SCHEDULE_MILLIS = 1000L;
    private static final int DEFAULT_MAX_REQ_HEADERS = 200;
    private static final long DEFAULT_DRAIN_AMOUNT = 65536L;
    private static long idleTimerScheduleMillis;
    private static long idleIntervalMillis;
    private static long drainAmount;
    private static int maxConnections;
    private static int maxIdleConnections;
    private static int maxReqHeaders;
    private static long maxReqTime;
    private static long maxRspTime;
    private static long reqRspTimerScheduleMillis;
    private static boolean debug;
    private static boolean noDelay;

    ServerConfig() {
    }

    static void checkLegacyProperties(final Logger logger) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("sun.net.httpserver.readTimeout") != null) {
                    logger.warning("sun.net.httpserver.readTimeout property is no longer used. Use sun.net.httpserver.maxReqTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.writeTimeout") != null) {
                    logger.warning("sun.net.httpserver.writeTimeout property is no longer used. Use sun.net.httpserver.maxRspTime instead.");
                }
                if (System.getProperty("sun.net.httpserver.selCacheTimeout") != null) {
                    logger.warning("sun.net.httpserver.selCacheTimeout property is no longer used.");
                }
                return null;
            }
        });
    }

    static boolean debugEnabled() {
        return debug;
    }

    static long getIdleIntervalMillis() {
        return idleIntervalMillis;
    }

    static long getIdleTimerScheduleMillis() {
        return idleTimerScheduleMillis;
    }

    static int getMaxConnections() {
        return maxConnections;
    }

    static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    static long getDrainAmount() {
        return drainAmount;
    }

    static int getMaxReqHeaders() {
        return maxReqHeaders;
    }

    static long getMaxReqTime() {
        return maxReqTime;
    }

    static long getMaxRspTime() {
        return maxRspTime;
    }

    static long getReqRspTimerScheduleMillis() {
        return reqRspTimerScheduleMillis;
    }

    static boolean noDelay() {
        return noDelay;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                idleIntervalMillis = Long.getLong("sun.net.httpserver.idleInterval", 30L) * 1000L;
                if (idleIntervalMillis <= 0L) {
                    idleIntervalMillis = 30000L;
                }
                idleTimerScheduleMillis = Long.getLong("sun.net.httpserver.clockTick", 10000L);
                if (idleTimerScheduleMillis <= 0L) {
                    idleTimerScheduleMillis = 10000L;
                }
                maxConnections = Integer.getInteger("jdk.httpserver.maxConnections", -1);
                maxIdleConnections = Integer.getInteger("sun.net.httpserver.maxIdleConnections", 200);
                drainAmount = Long.getLong("sun.net.httpserver.drainAmount", 65536L);
                maxReqHeaders = Integer.getInteger("sun.net.httpserver.maxReqHeaders", 200);
                maxReqTime = Long.getLong("sun.net.httpserver.maxReqTime", -1L);
                maxRspTime = Long.getLong("sun.net.httpserver.maxRspTime", -1L);
                reqRspTimerScheduleMillis = Long.getLong("sun.net.httpserver.timerMillis", 1000L);
                if (reqRspTimerScheduleMillis <= 0L) {
                    reqRspTimerScheduleMillis = 1000L;
                }
                debug = Boolean.getBoolean("sun.net.httpserver.debug");
                noDelay = Boolean.getBoolean("sun.net.httpserver.nodelay");
                return null;
            }
        });
    }
}

