/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.FileAttributeView;
import java.util.Arrays;
import sun.nio.fs.AixFileSystem;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class AixFileStore
extends UnixFileStore {
    AixFileStore(UnixPath unixPath) throws IOException {
        super(unixPath);
    }

    AixFileStore(UnixFileSystem unixFileSystem, UnixMountEntry unixMountEntry) throws IOException {
        super(unixFileSystem, unixMountEntry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        Object object;
        Object object2;
        AixFileSystem aixFileSystem = (AixFileSystem)this.file().getFileSystem();
        Object object3 = null;
        try {
            object2 = UnixNativeDispatcher.realpath(this.file());
            object3 = new UnixPath((UnixFileSystem)aixFileSystem, (byte[])object2);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file());
        }
        for (object2 = (Object)((UnixPath)object3).getParent(); object2 != null; object2 = ((UnixPath)object2).getParent()) {
            object = null;
            try {
                object = UnixFileAttributes.get((UnixPath)object2, true);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException((UnixPath)object2);
            }
            if (((UnixFileAttributes)object).dev() != this.dev()) break;
            object3 = object2;
        }
        object = ((UnixPath)object3).asByteArray();
        for (UnixMountEntry unixMountEntry : aixFileSystem.getMountEntries()) {
            if (!Arrays.equals((byte[])object, unixMountEntry.dir())) continue;
            return unixMountEntry;
        }
        throw new IOException("Mount point not found");
    }

    private boolean isExtendedAttributesEnabled(UnixPath unixPath) {
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        return super.supportsFileAttributeView(clazz);
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        return super.supportsFileAttributeView(string);
    }
}

