/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.Callable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleText;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import sun.lwawt.macosx.CAccessibility;
import sun.lwawt.macosx.CAccessible;

class CAccessibleText {
    CAccessibleText() {
    }

    static AccessibleEditableText getAccessibleEditableText(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<AccessibleEditableText>(){

            @Override
            public AccessibleEditableText call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                return accessibleContext.getAccessibleEditableText();
            }
        }, component);
    }

    static String getSelectedText(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText == null) {
                    return null;
                }
                return accessibleText.getSelectedText();
            }
        }, component);
    }

    static void setSelectedText(final Accessible accessible, Component component, final String string) {
        if (accessible == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return;
                }
                AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                if (accessibleEditableText == null) {
                    return;
                }
                int n = accessibleEditableText.getSelectionStart();
                int n2 = accessibleEditableText.getSelectionEnd();
                accessibleEditableText.replaceText(n, n2, string);
            }
        }, component);
    }

    static void setSelectedTextRange(final Accessible accessible, Component component, final int n, final int n2) {
        if (accessible == null) {
            return;
        }
        CAccessibility.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl;
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return;
                }
                AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                if (accessibleEditableText == null) {
                    return;
                }
                boolean bl2 = bl = n >= 0 && n2 >= n && n2 <= accessibleEditableText.getCharCount();
                if (!bl) {
                    return;
                }
                accessibleEditableText.selectText(n, n2);
            }
        }, component);
    }

    static String getTextRange(final AccessibleEditableText accessibleEditableText, final int n, final int n2, Component component) {
        if (accessibleEditableText == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return accessibleEditableText.getTextRange(n, n2);
            }
        }, component);
    }

    static int getCharacterIndexAtPosition(final Accessible accessible, Component component, final int n, final int n2) {
        if (accessible == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText == null) {
                    return null;
                }
                Point point = accessibleContext.getAccessibleComponent().getLocationOnScreen();
                int n3 = n - (int)point.getX();
                int n22 = n2 - (int)point.getY();
                return accessibleText.getIndexAtPoint(new Point(n3, n22));
            }
        }, component);
    }

    static int[] getSelectedTextRange(final Accessible accessible, Component component) {
        if (accessible == null) {
            return new int[2];
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return new int[2];
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText == null) {
                    return new int[2];
                }
                int[] nArray = new int[]{accessibleText.getSelectionStart(), accessibleText.getSelectionEnd()};
                return nArray;
            }
        }, component);
    }

    static int[] getVisibleCharacterRange(final Accessible accessible, Component component) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                return CAccessibleText.getVisibleCharacterRange(accessible);
            }
        }, component);
    }

    static int getLineNumberForIndex(final Accessible accessible, Component component, final int n) {
        if (accessible == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return CAccessibleText.getLineNumberForIndex(accessible, n);
            }
        }, component);
    }

    static int getLineNumberForInsertionPoint(final Accessible accessible, Component component) {
        if (accessible == null) {
            return 0;
        }
        return CAccessibility.invokeAndWait(new Callable<Integer>(){

            @Override
            public Integer call() {
                return CAccessibleText.getLineNumberForInsertionPoint(accessible);
            }
        }, component);
    }

    static int[] getRangeForLine(final Accessible accessible, Component component, final int n) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                return CAccessibleText.getRangeForLine(accessible, n);
            }
        }, component);
    }

    static int[] getRangeForIndex(final Accessible accessible, Component component, final int n) {
        if (accessible == null) {
            return new int[2];
        }
        return CAccessibility.invokeAndWait(new Callable<int[]>(){

            @Override
            public int[] call() {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return new int[2];
                }
                AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                if (accessibleEditableText == null) {
                    return new int[2];
                }
                int n4 = accessibleEditableText.getCharCount();
                if (n >= n4) {
                    return new int[2];
                }
                String string = accessibleEditableText.getAtIndex(2, n);
                int n2 = string.length();
                String string2 = accessibleEditableText.getTextRange(0, n4 - 1);
                int n3 = -1;
                for (int i = 0; n3 == -1 && i < n2; ++i) {
                    if (string2.regionMatches(true, n - i, string, 0, n2)) {
                        n3 = n - i;
                    }
                    if (!string2.regionMatches(true, n + i, string, 0, n2)) continue;
                    n3 = n + i;
                }
                int[] nArray = new int[]{n3, n3 + n2};
                return nArray;
            }
        }, component);
    }

    static double[] getBoundsForRange(final Accessible accessible, Component component, final int n, final int n2) {
        final double[] dArray = new double[4];
        if (accessible == null) {
            return dArray;
        }
        return CAccessibility.invokeAndWait(new Callable<double[]>(){

            @Override
            public double[] call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return dArray;
                }
                AccessibleText accessibleText = accessibleContext.getAccessibleText();
                if (accessibleText == null) {
                    accessibleContext.getAccessibleName();
                    accessibleContext.getAccessibleEditableText();
                    return dArray;
                }
                Rectangle rectangle = accessibleText.getCharacterBounds(n);
                Rectangle rectangle2 = accessibleText.getCharacterBounds(n + n2 - 1);
                if (rectangle2 == null || rectangle == null) {
                    return dArray;
                }
                Rectangle2D rectangle2D = ((Rectangle2D)rectangle).createUnion(rectangle2);
                if (rectangle2D.isEmpty()) {
                    return dArray;
                }
                double d = rectangle2D.getX();
                double d2 = rectangle2D.getY();
                Point point = accessibleContext.getAccessibleComponent().getLocationOnScreen();
                if (point == null) {
                    return dArray;
                }
                double d3 = point.getX() + d;
                double d4 = point.getY() + d2;
                dArray[0] = d3;
                dArray[1] = d4;
                dArray[2] = rectangle2D.getWidth();
                dArray[3] = rectangle2D.getHeight();
                return dArray;
            }
        }, component);
    }

    static String getStringForRange(final Accessible accessible, Component component, final int n, final int n2) {
        if (accessible == null) {
            return null;
        }
        return CAccessibility.invokeAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                if (accessibleContext == null) {
                    return null;
                }
                AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
                if (accessibleEditableText == null) {
                    return null;
                }
                int n3 = accessibleEditableText.getCharCount();
                return accessibleEditableText.getTextRange(Math.min(n3, n), Math.min(n3, n + n2));
            }
        }, component);
    }

    static int[] getVisibleCharacterRange(Accessible accessible) {
        Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
        if (!(accessible2 instanceof JTextComponent)) {
            return null;
        }
        JTextComponent jTextComponent = (JTextComponent)accessible2;
        Rectangle rectangle = jTextComponent.getVisibleRect();
        Point point = new Point(rectangle.x, rectangle.y);
        Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y);
        Point point3 = new Point(rectangle.x, rectangle.y + rectangle.height);
        Point point4 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        int n = Math.min(jTextComponent.viewToModel(point), jTextComponent.viewToModel(point2));
        int n2 = Math.max(jTextComponent.viewToModel(point3), jTextComponent.viewToModel(point4));
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new int[]{n, n2};
    }

    static int getLineNumberForIndex(Accessible accessible, int n) {
        Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
        if (!(accessible2 instanceof JTextComponent)) {
            return -1;
        }
        JTextComponent jTextComponent = (JTextComponent)accessible2;
        Element element = jTextComponent.getDocument().getDefaultRootElement();
        if (n == -1) {
            n = jTextComponent.getCaretPosition();
        }
        return element.getElementIndex(n);
    }

    static int getLineNumberForInsertionPoint(Accessible accessible) {
        return CAccessibleText.getLineNumberForIndex(accessible, -1);
    }

    static int[] getRangeForLine(Accessible accessible, int n) {
        Accessible accessible2 = CAccessible.getSwingAccessible(accessible);
        if (!(accessible2 instanceof JTextComponent)) {
            return null;
        }
        JTextComponent jTextComponent = (JTextComponent)accessible2;
        Element element = jTextComponent.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n);
        if (element2 == null) {
            return null;
        }
        return new int[]{element2.getStartOffset(), element2.getEndOffset()};
    }
}

