/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Objects;

final class ChronoZonedDateTimeImpl<D extends ChronoLocalDate>
implements ChronoZonedDateTime<D>,
Serializable {
    private static final long serialVersionUID = -5261813987200935591L;
    private final transient ChronoLocalDateTimeImpl<D> dateTime;
    private final transient ZoneOffset offset;
    private final transient ZoneId zone;

    static <R extends ChronoLocalDate> ChronoZonedDateTime<R> ofBest(ChronoLocalDateTimeImpl<R> chronoLocalDateTimeImpl, ZoneId zoneId, ZoneOffset zoneOffset) {
        ZoneOffset zoneOffset2;
        LocalDateTime localDateTime;
        Objects.requireNonNull(chronoLocalDateTimeImpl, "localDateTime");
        Objects.requireNonNull(zoneId, "zone");
        if (zoneId instanceof ZoneOffset) {
            return new ChronoZonedDateTimeImpl<R>(chronoLocalDateTimeImpl, (ZoneOffset)zoneId, zoneId);
        }
        ZoneRules zoneRules = zoneId.getRules();
        List<ZoneOffset> list = zoneRules.getValidOffsets(localDateTime = LocalDateTime.from(chronoLocalDateTimeImpl));
        if (list.size() == 1) {
            zoneOffset2 = list.get(0);
        } else if (list.size() == 0) {
            ZoneOffsetTransition zoneOffsetTransition = zoneRules.getTransition(localDateTime);
            chronoLocalDateTimeImpl = chronoLocalDateTimeImpl.plusSeconds(zoneOffsetTransition.getDuration().getSeconds());
            zoneOffset2 = zoneOffsetTransition.getOffsetAfter();
        } else {
            zoneOffset2 = zoneOffset != null && list.contains(zoneOffset) ? zoneOffset : list.get(0);
        }
        Objects.requireNonNull(zoneOffset2, "offset");
        return new ChronoZonedDateTimeImpl<R>(chronoLocalDateTimeImpl, zoneOffset2, zoneId);
    }

    static ChronoZonedDateTimeImpl<?> ofInstant(Chronology chronology, Instant instant, ZoneId zoneId) {
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        Objects.requireNonNull(zoneOffset, "offset");
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), zoneOffset);
        ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = (ChronoLocalDateTimeImpl)chronology.localDateTime(localDateTime);
        return new ChronoZonedDateTimeImpl(chronoLocalDateTimeImpl, zoneOffset, zoneId);
    }

    private ChronoZonedDateTimeImpl<D> create(Instant instant, ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofInstant(this.getChronology(), instant, zoneId);
    }

    static <R extends ChronoLocalDate> ChronoZonedDateTimeImpl<R> ensureValid(Chronology chronology, Temporal temporal) {
        ChronoZonedDateTimeImpl chronoZonedDateTimeImpl = (ChronoZonedDateTimeImpl)temporal;
        if (!chronology.equals(chronoZonedDateTimeImpl.getChronology())) {
            throw new ClassCastException("Chronology mismatch, required: " + chronology.getId() + ", actual: " + chronoZonedDateTimeImpl.getChronology().getId());
        }
        return chronoZonedDateTimeImpl;
    }

    private ChronoZonedDateTimeImpl(ChronoLocalDateTimeImpl<D> chronoLocalDateTimeImpl, ZoneOffset zoneOffset, ZoneId zoneId) {
        this.dateTime = Objects.requireNonNull(chronoLocalDateTimeImpl, "dateTime");
        this.offset = Objects.requireNonNull(zoneOffset, "offset");
        this.zone = Objects.requireNonNull(zoneId, "zone");
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    @Override
    public ChronoZonedDateTime<D> withEarlierOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (zoneOffsetTransition != null && zoneOffsetTransition.isOverlap() && !(zoneOffset = zoneOffsetTransition.getOffsetBefore()).equals(this.offset)) {
            return new ChronoZonedDateTimeImpl<D>(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    @Override
    public ChronoZonedDateTime<D> withLaterOffsetAtOverlap() {
        ZoneOffset zoneOffset;
        ZoneOffsetTransition zoneOffsetTransition = this.getZone().getRules().getTransition(LocalDateTime.from(this));
        if (zoneOffsetTransition != null && !(zoneOffset = zoneOffsetTransition.getOffsetAfter()).equals(this.getOffset())) {
            return new ChronoZonedDateTimeImpl<D>(this.dateTime, zoneOffset, this.zone);
        }
        return this;
    }

    @Override
    public ChronoLocalDateTime<D> toLocalDateTime() {
        return this.dateTime;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public ChronoZonedDateTime<D> withZoneSameLocal(ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofBest(this.dateTime, zoneId, this.offset);
    }

    @Override
    public ChronoZonedDateTime<D> withZoneSameInstant(ZoneId zoneId) {
        Objects.requireNonNull(zoneId, "zone");
        return this.zone.equals(zoneId) ? this : this.create(this.dateTime.toInstant(this.offset), zoneId);
    }

    @Override
    public boolean isSupported(TemporalField temporalField) {
        return temporalField instanceof ChronoField || temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public ChronoZonedDateTime<D> with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            switch (chronoField) {
                case INSTANT_SECONDS: {
                    return this.plus(l - this.toEpochSecond(), ChronoUnit.SECONDS);
                }
                case OFFSET_SECONDS: {
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l));
                    return this.create(this.dateTime.toInstant(zoneOffset), this.zone);
                }
            }
            return ChronoZonedDateTimeImpl.ofBest(this.dateTime.with(temporalField, l), this.zone, this.offset);
        }
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), temporalField.adjustInto(this, l));
    }

    @Override
    public ChronoZonedDateTime<D> plus(long l, TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.dateTime.plus(l, temporalUnit));
        }
        return ChronoZonedDateTimeImpl.ensureValid(this.getChronology(), temporalUnit.addTo(this, l));
    }

    @Override
    public long until(Temporal temporal, TemporalUnit temporalUnit) {
        Objects.requireNonNull(temporal, "endExclusive");
        ChronoZonedDateTime<? extends ChronoLocalDate> chronoZonedDateTime = this.getChronology().zonedDateTime(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            chronoZonedDateTime = chronoZonedDateTime.withZoneSameInstant(this.offset);
            return this.dateTime.until(chronoZonedDateTime.toLocalDateTime(), temporalUnit);
        }
        Objects.requireNonNull(temporalUnit, "unit");
        return temporalUnit.between(this, chronoZonedDateTime);
    }

    private Object writeReplace() {
        return new Ser(3, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.dateTime);
        objectOutput.writeObject(this.offset);
        objectOutput.writeObject(this.zone);
    }

    static ChronoZonedDateTime<?> readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ChronoLocalDateTime chronoLocalDateTime = (ChronoLocalDateTime)objectInput.readObject();
        ZoneOffset zoneOffset = (ZoneOffset)objectInput.readObject();
        ZoneId zoneId = (ZoneId)objectInput.readObject();
        return chronoLocalDateTime.atZone(zoneOffset).withZoneSameLocal(zoneId);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoZonedDateTime) {
            return this.compareTo((ChronoZonedDateTime)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.toLocalDateTime().hashCode() ^ this.getOffset().hashCode() ^ Integer.rotateLeft(this.getZone().hashCode(), 3);
    }

    @Override
    public String toString() {
        String string = this.toLocalDateTime().toString() + this.getOffset().toString();
        if (this.getOffset() != this.getZone()) {
            string = string + '[' + this.getZone().toString() + ']';
        }
        return string;
    }
}

