/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import sun.misc.Unsafe;

public class AtomicLongArray
implements Serializable {
    private static final long serialVersionUID = -2308431214976778248L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(long[].class);
    private static final int shift;
    private final long[] array;

    private long checkedByteOffset(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return AtomicLongArray.byteOffset(n);
    }

    private static long byteOffset(int n) {
        return ((long)n << shift) + (long)base;
    }

    public AtomicLongArray(int n) {
        this.array = new long[n];
    }

    public AtomicLongArray(long[] lArray) {
        this.array = (long[])lArray.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final long get(int n) {
        return this.getRaw(this.checkedByteOffset(n));
    }

    private long getRaw(long l) {
        return unsafe.getLongVolatile(this.array, l);
    }

    public final void set(int n, long l) {
        unsafe.putLongVolatile(this.array, this.checkedByteOffset(n), l);
    }

    public final void lazySet(int n, long l) {
        unsafe.putOrderedLong(this.array, this.checkedByteOffset(n), l);
    }

    public final long getAndSet(int n, long l) {
        return unsafe.getAndSetLong(this.array, this.checkedByteOffset(n), l);
    }

    public final boolean compareAndSet(int n, long l, long l2) {
        return this.compareAndSetRaw(this.checkedByteOffset(n), l, l2);
    }

    private boolean compareAndSetRaw(long l, long l2, long l3) {
        return unsafe.compareAndSwapLong(this.array, l, l2, l3);
    }

    public final boolean weakCompareAndSet(int n, long l, long l2) {
        return this.compareAndSet(n, l, l2);
    }

    public final long getAndIncrement(int n) {
        return this.getAndAdd(n, 1L);
    }

    public final long getAndDecrement(int n) {
        return this.getAndAdd(n, -1L);
    }

    public final long getAndAdd(int n, long l) {
        return unsafe.getAndAddLong(this.array, this.checkedByteOffset(n), l);
    }

    public final long incrementAndGet(int n) {
        return this.getAndAdd(n, 1L) + 1L;
    }

    public final long decrementAndGet(int n) {
        return this.getAndAdd(n, -1L) - 1L;
    }

    public long addAndGet(int n, long l) {
        return this.getAndAdd(n, l) + l;
    }

    public final long getAndUpdate(int n, LongUnaryOperator longUnaryOperator) {
        long l;
        long l2;
        long l3 = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l3, l2 = this.getRaw(l3), l = longUnaryOperator.applyAsLong(l2))) {
        }
        return l2;
    }

    public final long updateAndGet(int n, LongUnaryOperator longUnaryOperator) {
        long l;
        long l2;
        long l3 = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l3, l2 = this.getRaw(l3), l = longUnaryOperator.applyAsLong(l2))) {
        }
        return l;
    }

    public final long getAndAccumulate(int n, long l, LongBinaryOperator longBinaryOperator) {
        long l2;
        long l3;
        long l4 = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l4, l3 = this.getRaw(l4), l2 = longBinaryOperator.applyAsLong(l3, l))) {
        }
        return l3;
    }

    public final long accumulateAndGet(int n, long l, LongBinaryOperator longBinaryOperator) {
        long l2;
        long l3;
        long l4 = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l4, l3 = this.getRaw(l4), l2 = longBinaryOperator.applyAsLong(l3, l))) {
        }
        return l2;
    }

    public String toString() {
        int n = this.array.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(this.getRaw(AtomicLongArray.byteOffset(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    static {
        int n = unsafe.arrayIndexScale(long[].class);
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        shift = 31 - Integer.numberOfLeadingZeros(n);
    }
}

