/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

class ByteBufferAsFloatBufferB
extends FloatBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsFloatBufferB(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 2, byteBuffer.remaining() >> 2);
        this.bb = byteBuffer;
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.offset = n2;
    }

    ByteBufferAsFloatBufferB(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.bb = byteBuffer;
        this.offset = n5;
    }

    @Override
    public FloatBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        int n4 = (n2 << 2) + this.offset;
        assert (n4 >= 0);
        return new ByteBufferAsFloatBufferB(this.bb, -1, 0, n3, n3, n4);
    }

    @Override
    public FloatBuffer duplicate() {
        return new ByteBufferAsFloatBufferB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        return new ByteBufferAsFloatBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return (n << 2) + this.offset;
    }

    @Override
    public float get() {
        return Bits.getFloatB(this.bb, this.ix(this.nextGetIndex()));
    }

    @Override
    public float get(int n) {
        return Bits.getFloatB(this.bb, this.ix(this.checkIndex(n)));
    }

    @Override
    public FloatBuffer put(float f) {
        Bits.putFloatB(this.bb, this.ix(this.nextPutIndex()), f);
        return this;
    }

    @Override
    public FloatBuffer put(int n, float f) {
        Bits.putFloatB(this.bb, this.ix(this.checkIndex(n)), f);
        return this;
    }

    @Override
    public FloatBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n2));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n << 2);
        byteBuffer2.compact();
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

