/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Type;
import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.GenericRecoveredTypeBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class JavacRecoveredTypeBinding
extends JavacTypeBinding {
    private final ASTNode domNode;

    public JavacRecoveredTypeBinding(Type type, ASTNode domName, JavacBindingResolver resolver) {
        super(type, type != null ? type.tsym : null, null, null, false, resolver);
        this.domNode = domName;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.domNode.toString().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavacRecoveredTypeBinding)) return false;
        JavacRecoveredTypeBinding recovered = (JavacRecoveredTypeBinding)obj;
        if (!Objects.equals(recovered.domNode.toString(), this.domNode.toString())) return false;
        if (!Objects.equals(recovered.domNode.getAST(), this.domNode.getAST())) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public JavacTypeBinding getComponentType() {
        Type.ArrayType javacArrayType;
        Type type = this.type;
        if (type instanceof Type.ArrayType && (javacArrayType = (Type.ArrayType)type).isErroneous()) {
            ASTNode aSTNode;
            if (this.getDimensions() == 1 && (aSTNode = this.domNode) instanceof ArrayType) {
                ArrayType domArrayType = (ArrayType)aSTNode;
                return this.resolver.bindings.getRecoveredTypeBinding(javacArrayType.elemtype, domArrayType.getElementType());
            }
            ASTNode aSTNode2 = this.domNode;
            if (aSTNode2 instanceof org.eclipse.jdt.core.dom.Type) {
                org.eclipse.jdt.core.dom.Type t = (org.eclipse.jdt.core.dom.Type)aSTNode2;
                return this.resolver.bindings.getRecoveredTypeBinding(javacArrayType.elemtype, t);
            }
            aSTNode2 = this.domNode;
            if (aSTNode2 instanceof Name) {
                Name n = (Name)aSTNode2;
                return this.resolver.bindings.getRecoveredTypeBinding(javacArrayType.elemtype, n);
            }
        }
        return super.getComponentType();
    }

    @Override
    public JavacTypeBinding getElementType() {
        if (this.type != null) {
            return (JavacTypeBinding)super.getElementType();
        }
        ASTNode aSTNode = this.domNode;
        if (aSTNode instanceof ArrayType) {
            ArrayType domArrayType = (ArrayType)aSTNode;
            org.eclipse.jdt.core.dom.Type cursor = domArrayType.getElementType();
            while (cursor instanceof ArrayType) {
                ArrayType at = (ArrayType)cursor;
                cursor = at.getElementType();
            }
            return this.resolver.bindings.getRecoveredTypeBinding(this.type, cursor);
        }
        return null;
    }

    @Override
    public IPackageBinding getPackage() {
        if (this.isArray()) {
            return null;
        }
        if (this.type == null || this.type.isErroneous() || this.type instanceof Type.PackageType) {
            Name name = this.domName();
            if (name instanceof QualifiedName) {
                QualifiedName qname = (QualifiedName)name;
                return this.resolver.bindings.getPackageBinding(qname.getQualifier());
            }
            for (ASTNode current = this.domNode; current != null; current = current.getParent()) {
                AbstractTypeDeclaration typeDecl;
                ITypeBinding declaringTypeBinding;
                if (!(current instanceof AbstractTypeDeclaration) || (declaringTypeBinding = (typeDecl = (AbstractTypeDeclaration)current).resolveBinding()) == null) continue;
                return declaringTypeBinding.getPackage();
            }
            return this.resolver.bindings.getPackageBinding("");
        }
        return super.getPackage();
    }

    private Name domName() {
        ASTNode toConsider = this.domNode;
        if (toConsider instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)toConsider;
            toConsider = parameterizedType.getType();
        }
        if (toConsider instanceof SimpleType) {
            SimpleType type = (SimpleType)toConsider;
            return type.getName();
        }
        if (toConsider instanceof Name) {
            Name name = (Name)toConsider;
            return name;
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        if (this.isArray()) {
            return this.getComponentType().getQualifiedName() + "[]";
        }
        if (this.type == null || this.type.isErroneous()) {
            Name name;
            StringBuilder res = new StringBuilder(this.getPackage().getName());
            if (!res.isEmpty()) {
                res.append('.');
            }
            if ((name = this.domName()) == null) {
                return "";
            }
            String simpleName = name.isSimpleName() ? ((SimpleName)name).getIdentifier() : ((QualifiedName)name).getName().getIdentifier();
            res.append(simpleName);
            return res.toString();
        }
        return super.getQualifiedName();
    }

    @Override
    public boolean isRecovered() {
        return true;
    }

    @Override
    public IJavaElement getJavaElement() {
        IJavaElement iJavaElement;
        IPackageBinding pack = this.getPackage();
        if (pack != null && (iJavaElement = pack.getJavaElement()) instanceof IPackageFragment) {
            IPackageFragment pkgFragment = (IPackageFragment)iJavaElement;
            return pkgFragment.getCompilationUnit(this.getName() + ".java").getType(this.getName());
        }
        return null;
    }

    @Override
    public boolean isParameterizedType() {
        return this.domNode instanceof ParameterizedType;
    }

    @Override
    public boolean isAnonymous() {
        if (this.typeSymbol != null) {
            return super.isAnonymous();
        }
        return this.domNode.getParent() instanceof AnonymousClassDeclaration;
    }

    @Override
    public boolean isEnum() {
        if (this.typeSymbol != null) {
            return super.isEnum();
        }
        return this.domNode.getParent() instanceof EnumDeclaration;
    }

    @Override
    public boolean isMember() {
        if (this.typeSymbol != null) {
            return super.isMember();
        }
        return false;
    }

    @Override
    public boolean isIntersectionType() {
        if (this.typeSymbol != null) {
            return super.isAnonymous();
        }
        return this.domNode instanceof IntersectionType;
    }

    @Override
    public boolean isInterface() {
        if (this.typeSymbol != null) {
            return super.isInterface();
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        if (this.typeSymbol != null) {
            super.isLocal();
        }
        return false;
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        ASTNode aSTNode;
        if (this.isParameterizedType() && (aSTNode = this.domNode) instanceof org.eclipse.jdt.core.dom.Type) {
            org.eclipse.jdt.core.dom.Type domType = (org.eclipse.jdt.core.dom.Type)aSTNode;
            return new GenericRecoveredTypeBinding(this.resolver, domType, this);
        }
        return super.getTypeDeclaration();
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        return new IVariableBinding[0];
    }

    @Override
    public IMethodBinding[] getDeclaredMethods() {
        return new IMethodBinding[0];
    }

    @Override
    public ITypeBinding getDeclaringClass() {
        if (this.typeSymbol != null) {
            return super.getDeclaringClass();
        }
        return null;
    }

    @Override
    public String getName(boolean checkParameterized, boolean sourceName) {
        if (this.typeSymbol != null) {
            return super.getName(checkParameterized, sourceName);
        }
        return this.domNode.toString();
    }

    @Override
    public String getQualifiedName(boolean includeParams) {
        CompilationUnit cu;
        ASTNode cursor;
        if (this.typeSymbol != null) {
            return super.getQualifiedName(includeParams);
        }
        for (cursor = this.domNode; cursor != null && !(cursor instanceof CompilationUnit); cursor = cursor.getParent()) {
        }
        StringBuilder qualifiedNameBuilder = new StringBuilder();
        if (cursor instanceof CompilationUnit && (cu = (CompilationUnit)cursor).getPackage() != null) {
            qualifiedNameBuilder.append(cu.getPackage().getName().toString());
            qualifiedNameBuilder.append(".");
        }
        qualifiedNameBuilder.append(this.domNode.toString());
        return qualifiedNameBuilder.toString();
    }

    @Override
    public String getKey() {
        if (this.type != null) {
            return super.getKey();
        }
        return "L" + this.getQualifiedName() + ";";
    }

    @Override
    public String getKey(boolean includeTypeParameters, boolean useSlashes) {
        if (this.type != null) {
            return super.getKey(includeTypeParameters, useSlashes);
        }
        if (useSlashes) {
            return "L" + this.getQualifiedName().replace('.', '/') + ";";
        }
        return "L" + this.getQualifiedName() + ";";
    }

    @Override
    public String getGenericTypeSignature(boolean useSlashes) {
        if (this.type == null) {
            return this.getKey(false, useSlashes);
        }
        return super.getGenericTypeSignature(useSlashes);
    }

    @Override
    public ITypeBinding[] getInterfaces() {
        if (this.type != null) {
            return super.getInterfaces();
        }
        return new ITypeBinding[0];
    }

    @Override
    public ITypeBinding getSuperclass() {
        if (this.type != null) {
            return super.getSuperclass();
        }
        return null;
    }
}

