/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.model;

import org.codehaus.jdt.groovy.model.ICodeSelectHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

class CodeSelectHelperFactory {
    private static final String CODE_SELECT_HELPER_EXTENSION = "org.eclipse.jdt.groovy.core.codeSelectHelper";
    static ICodeSelectHelper selectHelper;

    static {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(CODE_SELECT_HELPER_EXTENSION);
        IExtension[] exts = extPoint.getExtensions();
        if (exts.length < 1) {
            throw new IllegalArgumentException("No Code Select Helper found");
        }
        if (exts.length > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Too many Code Select Helpers found:\n");
            IExtension[] iExtensionArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                sb.append("    " + ext.getNamespaceIdentifier() + "." + ext.getSimpleIdentifier());
                ++n2;
            }
            throw new IllegalArgumentException(sb.toString());
        }
        IConfigurationElement[] elts = exts[0].getConfigurationElements();
        if (elts.length < 1) {
            throw new IllegalArgumentException("No Code Select Helper found");
        }
        if (elts.length > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Too many Code Select Helpers found:\n");
            IConfigurationElement[] iConfigurationElementArray = elts;
            int n = elts.length;
            int n3 = 0;
            while (n3 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n3];
                sb.append("    " + elt.getNamespaceIdentifier());
                ++n3;
            }
            throw new IllegalArgumentException(sb.toString());
        }
        try {
            selectHelper = (ICodeSelectHelper)elts[0].createExecutableExtension("class");
        }
        catch (CoreException e) {
            throw new IllegalArgumentException(e);
        }
    }

    CodeSelectHelperFactory() {
    }

    public static void setSelectHelper(ICodeSelectHelper newSelectHelper) {
        selectHelper = newSelectHelper;
    }
}

