/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CapturingContext;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

class ConstraintExpressionFormula
extends ConstraintFormula {
    Expression left;
    boolean isSoft;

    ConstraintExpressionFormula(Expression expression, TypeBinding type, int relation) {
        this.left = expression;
        this.right = type;
        this.relation = relation;
    }

    ConstraintExpressionFormula(Expression expression, TypeBinding type, int relation, boolean isSoft) {
        this(expression, type, relation);
        this.isSoft = isSoft;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object reduce(InferenceContext18 inferenceContext) throws InferenceFailureException {
        block46: {
            if ((this.right.tagBits & 128L) != 0L) {
                inferenceContext.missingType = this.right;
                return ConstraintExpressionFormula.TRUE;
            }
            if (this.relation == 8) {
                if (this.left.isPotentiallyCompatibleWith(this.right, inferenceContext.scope)) {
                    v0 = ConstraintExpressionFormula.TRUE;
                    return v0;
                }
                v0 = ConstraintExpressionFormula.FALSE;
                return v0;
            }
            if (this.right.isProperType(true)) {
                if (!this.left.isCompatibleWith(this.right, inferenceContext.scope)) {
                    if (this.left.isBoxingCompatibleWith(this.right, inferenceContext.scope) == false) return ConstraintExpressionFormula.FALSE;
                }
                if (this.left.resolvedType == null) return ConstraintExpressionFormula.TRUE;
                if (this.left.resolvedType.needsUncheckedConversion(this.right) == false) return ConstraintExpressionFormula.TRUE;
                inferenceContext.usesUncheckedConversion = true;
                return ConstraintExpressionFormula.TRUE;
            }
            if (!this.canBePolyExpression(this.left)) {
                exprType = this.left.resolvedType;
                if (exprType != null) {
                    if (exprType.isValidBinding() != false) return ConstraintTypeFormula.create(exprType, this.right, 1, this.isSoft);
                }
                if (this.left instanceof MessageSend == false) return ConstraintExpressionFormula.FALSE;
                if (((MessageSend)this.left).actualReceiverType instanceof InferenceVariable == false) return ConstraintExpressionFormula.FALSE;
                return null;
            }
            if (!(this.left instanceof Invocation)) break block46;
            invocation = (Invocation)this.left;
            previousMethod = invocation.binding();
            if (previousMethod == null) {
                return null;
            }
            method = previousMethod;
            method = previousMethod.shallowOriginal();
            prevInvocation = inferenceContext.enterPolyInvocation(invocation, invocation.arguments());
            innerCtx = null;
            arguments = invocation.arguments();
            argumentTypes = arguments == null ? Binding.NO_PARAMETERS : new TypeBinding[arguments.length];
            i = 0;
            while (true) {
                block47: {
                    if (i < argumentTypes.length) break block47;
                    if (!(previousMethod instanceof ParameterizedGenericMethodBinding)) ** GOTO lbl68
                    innerCtx = invocation.getInferenceContext((ParameterizedGenericMethodBinding)previousMethod);
                    if (innerCtx != null) ** GOTO lbl-1000
                    exprType = this.left.resolvedType;
                    if (exprType == null || !exprType.isValidBinding()) {
                        var13_25 = ConstraintExpressionFormula.FALSE;
                        inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                        return var13_25;
                    }
                    ** GOTO lbl-1000
                }
                argumentTypes[i] = arguments[i].resolvedType;
                ++i;
            }
            {
                catch (Throwable var12_38) {
                    inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                    throw var12_38;
                }
lbl-1000:
                // 1 sources

                {
                    var13_26 = ConstraintTypeFormula.create(exprType, this.right, 1, this.isSoft);
                    inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                    return var13_26;
                }
lbl-1000:
                // 1 sources

                {
                    if (!innerCtx.isInexactVarargsInference()) ** GOTO lbl-1000
                    var13_27 = ConstraintExpressionFormula.TRUE;
                    inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                    return var13_27;
                }
lbl-1000:
                // 1 sources

                {
                    if (innerCtx.stepCompleted < 1) {
                        var13_28 = ConstraintExpressionFormula.FALSE;
                        inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                        return var13_28;
                    }
                    inferenceContext.integrateInnerInferenceB2(innerCtx);
                    ** GOTO lbl-1000
                }
lbl68:
                // 1 sources

                inferenceContext.inferenceKind = inferenceContext.getInferenceKind(previousMethod, argumentTypes);
                isDiamond = method.isConstructor() != false && this.left.isPolyExpression(method) != false;
                ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext, method, argumentTypes, isDiamond, inferenceContext.inferenceKind);
                CapturingContext.enter(invocation.sourceStart(), invocation.sourceEnd(), inferenceContext.scope);
                if (inferenceContext.reduce()) ** GOTO lbl-1000
                var11_32 = ConstraintExpressionFormula.FALSE;
                inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                return var11_32;
                finally {
                    CapturingContext.leave();
                }
            }
lbl-1000:
            // 2 sources

            {
                if (!inferenceContext.computeB3(invocation, this.right, method)) {
                    var13_29 = ConstraintExpressionFormula.FALSE;
                    inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                    return var13_29;
                }
                inferenceContext.resumeSuspendedInference(prevInvocation, innerCtx);
                return null;
            }
        }
        if (this.left instanceof ConditionalExpression) {
            conditional = (ConditionalExpression)this.left;
            return new ConstraintFormula[]{new ConstraintExpressionFormula(conditional.valueIfTrue, this.right, this.relation, this.isSoft), new ConstraintExpressionFormula(conditional.valueIfFalse, this.right, this.relation, this.isSoft)};
        }
        var3_7 = this.left;
        if (var3_7 instanceof SwitchExpression) {
            se = (SwitchExpression)var3_7;
            cfs = new ConstraintFormula[se.resultExpressions().size()];
            i = 0;
            arguments = se.resultExpressions().iterator();
            while (true) {
                if (!arguments.hasNext()) {
                    return cfs;
                }
                re = arguments.next();
                cfs[i++] = new ConstraintExpressionFormula(re, this.right, this.relation, this.isSoft);
            }
        }
        if (!(this.left instanceof LambdaExpression)) {
            if (this.left instanceof ReferenceExpression == false) return ConstraintExpressionFormula.FALSE;
            return this.reduceReferenceExpressionCompatibility((ReferenceExpression)this.left, inferenceContext);
        }
        lambda = (LambdaExpression)this.left;
        scope = lambda.enclosingScope;
        if (this.right instanceof InferenceVariable) {
            return ConstraintExpressionFormula.TRUE;
        }
        if (!this.right.isFunctionalInterface(scope)) {
            return ConstraintExpressionFormula.FALSE;
        }
        t = (ReferenceBinding)this.right;
        withWildCards = InferenceContext18.parameterizedWithWildcard(t);
        if (withWildCards != null) {
            t = ConstraintExpressionFormula.findGroundTargetType(inferenceContext, scope, lambda, withWildCards);
        }
        if (t == null) {
            return ConstraintExpressionFormula.FALSE;
        }
        functionType = t.getSingleAbstractMethod(scope, true);
        if (functionType == null) {
            return ConstraintExpressionFormula.FALSE;
        }
        parameters = functionType.parameters;
        if (parameters.length != lambda.arguments().length) {
            return ConstraintExpressionFormula.FALSE;
        }
        if (lambda.argumentsTypeElided()) {
            var13_30 = parameters;
            var12_39 = parameters.length;
            var11_33 = 0;
            while (var11_33 < var12_39) {
                parameter = var13_30[var11_33];
                if (!parameter.isProperType(true)) {
                    return ConstraintExpressionFormula.FALSE;
                }
                ++var11_33;
            }
        }
        if ((lambda = lambda.resolveExpressionExpecting(t, inferenceContext.scope)) == null) {
            return ConstraintExpressionFormula.FALSE;
        }
        if (functionType.returnType == TypeBinding.VOID ? lambda.isVoidCompatible() == false : lambda.isValueCompatible() == false) {
            return ConstraintExpressionFormula.FALSE;
        }
        result = new ArrayList<ConstraintFormula>();
        if (!lambda.argumentsTypeElided()) {
            arguments = lambda.arguments();
            i = 0;
            while (true) {
                if (i >= parameters.length) {
                    if (lambda.resolvedType == null) break;
                    result.add(ConstraintTypeFormula.create(lambda.resolvedType, this.right, 2));
                    break;
                }
                result.add(ConstraintTypeFormula.create(parameters[i], arguments[i].type.resolvedType, 4));
                ++i;
            }
        }
        if (functionType.returnType != TypeBinding.VOID) {
            r = functionType.returnType;
            exprs = lambda.resultExpressions();
            i = 0;
            v1 = length = exprs == null ? 0 : exprs.length;
            while (i < length) {
                expr = exprs[i];
                if (r.isProperType(true) && expr.resolvedType != null) {
                    exprType = expr.resolvedType;
                    if (!(expr.isConstantValueOfTypeAssignableToType(exprType, r) || exprType.isCompatibleWith(r) || expr.isBoxingCompatible(exprType, r, expr, scope))) {
                        return ConstraintExpressionFormula.FALSE;
                    }
                } else {
                    result.add(new ConstraintExpressionFormula(expr, r, 1, this.isSoft));
                }
                ++i;
            }
        }
        if (result.size() != 0) return result.toArray(new ConstraintFormula[result.size()]);
        return ConstraintExpressionFormula.TRUE;
    }

    public static ReferenceBinding findGroundTargetType(InferenceContext18 inferenceContext, BlockScope scope, LambdaExpression lambda, ParameterizedTypeBinding targetTypeWithWildCards) {
        if (lambda.argumentsTypeElided()) {
            return targetTypeWithWildCards.getNonWildcardParameterization(scope);
        }
        InferenceContext18.SuspendedInferenceRecord previous = inferenceContext.enterLambda(lambda);
        try {
            ReferenceBinding referenceBinding = inferenceContext.inferFunctionalInterfaceParameterization(lambda, scope, targetTypeWithWildCards);
            return referenceBinding;
        }
        finally {
            inferenceContext.resumeSuspendedInference(previous, null);
        }
    }

    private boolean canBePolyExpression(Expression expr) {
        ExpressionContext previousExpressionContext = expr.getExpressionContext();
        if (previousExpressionContext == ExpressionContext.VANILLA_CONTEXT) {
            this.left.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
        }
        try {
            boolean bl = expr.isPolyExpression();
            return bl;
        }
        finally {
            expr.setExpressionContext(previousExpressionContext);
        }
    }

    private Object reduceReferenceExpressionCompatibility(ReferenceExpression reference, InferenceContext18 inferenceContext) {
        TypeBinding rPrime;
        TypeBinding r;
        MethodBinding potentiallyApplicable;
        TypeBinding t = this.right;
        if (t.isProperType(true)) {
            throw new IllegalStateException("Should not reach here with T being a proper type");
        }
        if (!t.isFunctionalInterface(inferenceContext.scope)) {
            return FALSE;
        }
        MethodBinding functionType = t.getSingleAbstractMethod(inferenceContext.scope, true);
        if (functionType == null) {
            return FALSE;
        }
        MethodBinding methodBinding = potentiallyApplicable = (reference = reference.resolveExpressionExpecting(t, inferenceContext.scope)) != null ? reference.binding : null;
        if (potentiallyApplicable == null) {
            return FALSE;
        }
        if (reference.isExactMethodReference()) {
            ArrayList<ConstraintTypeFormula> newConstraints = new ArrayList<ConstraintTypeFormula>();
            TypeBinding[] p = functionType.parameters;
            int n = p.length;
            TypeBinding[] pPrime = potentiallyApplicable.parameters;
            int k = pPrime.length;
            int offset = 0;
            if (n == k + 1) {
                newConstraints.add(ConstraintTypeFormula.create(p[0], reference.lhs.resolvedType, 1));
                offset = 1;
            }
            int i = offset;
            while (i < n) {
                newConstraints.add(ConstraintTypeFormula.create(p[i], pPrime[i - offset], 1));
                ++i;
            }
            TypeBinding r2 = functionType.returnType;
            if (r2 != TypeBinding.VOID) {
                TypeBinding rAppl;
                TypeBinding typeBinding = rAppl = potentiallyApplicable.isConstructor() && !reference.isArrayConstructorReference() ? potentiallyApplicable.declaringClass : potentiallyApplicable.returnType;
                if (rAppl == TypeBinding.VOID) {
                    return FALSE;
                }
                TypeBinding rPrime2 = rAppl.capture(inferenceContext.scope, reference.sourceStart, reference.sourceEnd);
                newConstraints.add(ConstraintTypeFormula.create(rPrime2, r2, 1));
            }
            return newConstraints.toArray(new ConstraintFormula[newConstraints.size()]);
        }
        int n = functionType.parameters.length;
        int i = 0;
        while (i < n) {
            if (!functionType.parameters[i].isProperType(true)) {
                return FALSE;
            }
            ++i;
        }
        MethodBinding compileTimeDecl = potentiallyApplicable;
        if (!compileTimeDecl.isValidBinding()) {
            return FALSE;
        }
        TypeBinding typeBinding = r = functionType.isConstructor() ? functionType.declaringClass : functionType.returnType;
        if (r.id == 6) {
            return TRUE;
        }
        MethodBinding original = compileTimeDecl.shallowOriginal();
        if (this.needsInference(reference, original)) {
            TypeBinding[] argumentTypes;
            if (t.isParameterizedType()) {
                MethodBinding capturedFunctionType = ((ParameterizedTypeBinding)t).getSingleAbstractMethod(inferenceContext.scope, true, reference.sourceStart, reference.sourceEnd);
                argumentTypes = capturedFunctionType.parameters;
            } else {
                argumentTypes = functionType.parameters;
            }
            InferenceContext18.SuspendedInferenceRecord prevInvocation = inferenceContext.enterPolyInvocation(reference, reference.createPseudoExpressions(argumentTypes));
            InferenceContext18 innerContext = null;
            try {
                innerContext = reference.getInferenceContext((ParameterizedMethodBinding)compileTimeDecl);
                if (innerContext != null) {
                    innerContext.pushBoundsTo(inferenceContext);
                }
                int innerInferenceKind = this.determineInferenceKind(compileTimeDecl, argumentTypes, innerContext);
                ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext, original, argumentTypes, original.isConstructor(), innerInferenceKind);
                if (!inferenceContext.computeB3(reference, r, original)) {
                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                return null;
            }
            catch (InferenceFailureException e) {
                ConstraintTypeFormula constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            finally {
                inferenceContext.resumeSuspendedInference(prevInvocation, innerContext);
            }
        }
        TypeBinding typeBinding2 = rPrime = compileTimeDecl.isConstructor() ? compileTimeDecl.declaringClass : compileTimeDecl.returnType.capture(inferenceContext.scope, reference.sourceStart(), reference.sourceEnd());
        if (rPrime.id == 6) {
            return FALSE;
        }
        if (compileTimeDecl.isConstructor() && inferenceContext.environment.usesNullTypeAnnotations()) {
            rPrime = inferenceContext.environment.createNonNullAnnotatedType(rPrime);
        }
        return ConstraintTypeFormula.create(rPrime, r, 1, this.isSoft);
    }

    private boolean needsInference(ReferenceExpression reference, MethodBinding original) {
        TypeBinding compileTimeReturn;
        if (reference.typeArguments != null) {
            return false;
        }
        if (original.isConstructor()) {
            if (original.declaringClass.typeVariables() != Binding.NO_TYPE_VARIABLES && reference.receiverType.isRawType()) {
                return true;
            }
            compileTimeReturn = original.declaringClass;
        } else {
            compileTimeReturn = original.returnType;
        }
        return original.typeVariables() != Binding.NO_TYPE_VARIABLES && compileTimeReturn.mentionsAny(original.typeVariables(), -1);
    }

    private int determineInferenceKind(MethodBinding original, TypeBinding[] argumentTypes, InferenceContext18 innerContext) {
        if (innerContext != null) {
            return innerContext.inferenceKind;
        }
        if (original.isVarargs()) {
            TypeBinding expectedLast;
            TypeBinding providedLast;
            int expectedLen = original.parameters.length;
            int providedLen = argumentTypes.length;
            if (expectedLen < providedLen) {
                return 3;
            }
            if (expectedLen == providedLen && !(providedLast = argumentTypes[expectedLen - 1]).isCompatibleWith(expectedLast = original.parameters[expectedLen - 1]) && expectedLast.isArrayType() && providedLast.isCompatibleWith(expectedLast = expectedLast.leafComponentType())) {
                return 3;
            }
        }
        return 1;
    }

    static void inferInvocationApplicability(InferenceContext18 inferenceContext, MethodBinding method, TypeBinding[] arguments, boolean isDiamond, int checkType) {
        TypeBinding[] typeVariables = method.getAllTypeVariables(isDiamond);
        InferenceVariable[] inferenceVariables = inferenceContext.createInitialBoundSet((TypeVariableBinding[])typeVariables);
        int paramLength = method.parameters.length;
        TypeBinding varArgsType = null;
        if (method.isVarargs()) {
            int varArgPos = paramLength - 1;
            varArgsType = method.parameters[varArgPos];
        }
        inferenceContext.createInitialConstraintsForParameters(method.parameters, checkType == 3, varArgsType, method);
        inferenceContext.addThrowsContraints(typeVariables, inferenceVariables, method.thrownExceptions);
    }

    static boolean inferPolyInvocationType(InferenceContext18 inferenceContext, InvocationSite invocationSite, TypeBinding targetType, MethodBinding method) throws InferenceFailureException {
        TypeBinding[] typeArguments = invocationSite.genericTypeArguments();
        if (typeArguments == null) {
            ConstraintTypeFormula newConstraint;
            TypeBinding returnType;
            TypeBinding typeBinding = returnType = method.isConstructor() ? method.declaringClass : method.returnType;
            if (returnType == TypeBinding.VOID) {
                throw new InferenceFailureException("expression has no value");
            }
            if (inferenceContext.usesUncheckedConversion) {
                TypeBinding erasure = ConstraintExpressionFormula.getRealErasure(returnType, inferenceContext.environment);
                ConstraintTypeFormula newConstraint2 = ConstraintTypeFormula.create(erasure, targetType, 1);
                return inferenceContext.reduceAndIncorporate(newConstraint2);
            }
            TypeBinding rTheta = inferenceContext.substitute(returnType);
            ParameterizedTypeBinding parameterizedType = InferenceContext18.parameterizedWithWildcard(rTheta);
            if (parameterizedType != null && parameterizedType.arguments != null) {
                TypeBinding[] arguments = parameterizedType.arguments;
                TypeBinding[] betas = inferenceContext.addTypeVariableSubstitutions(arguments, false);
                ParameterizedTypeBinding gbeta = inferenceContext.environment.createParameterizedType(parameterizedType.genericType(), betas, parameterizedType.enclosingType(), parameterizedType.getTypeAnnotations());
                inferenceContext.currentBounds.captures.put(gbeta, parameterizedType);
                inferenceContext.currentBounds.allCaptures.put(gbeta, parameterizedType);
                int i = 0;
                int length = arguments.length;
                while (i < length) {
                    if (arguments[i].isWildcard()) {
                        WildcardBinding wc = (WildcardBinding)arguments[i];
                        switch (wc.boundKind) {
                            case 1: {
                                inferenceContext.currentBounds.addBound(new TypeBound((InferenceVariable)betas[i], wc.bound(), 2), inferenceContext.environment);
                                break;
                            }
                            case 2: {
                                inferenceContext.currentBounds.addBound(new TypeBound((InferenceVariable)betas[i], wc.bound(), 3), inferenceContext.environment);
                            }
                        }
                    }
                    ++i;
                }
                ConstraintTypeFormula newConstraint3 = ConstraintTypeFormula.create(gbeta, targetType, 1);
                return inferenceContext.reduceAndIncorporate(newConstraint3);
            }
            if (rTheta.leafComponentType() instanceof InferenceVariable) {
                TypeBinding wrapper;
                InferenceVariable alpha = (InferenceVariable)rTheta.leafComponentType();
                TypeBinding targetLeafType = targetType.leafComponentType();
                boolean toResolve = false;
                if (inferenceContext.currentBounds.condition18_5_2_bullet_3_3_1(alpha, targetLeafType)) {
                    toResolve = true;
                } else if (inferenceContext.currentBounds.condition18_5_2_bullet_3_3_2(alpha, targetLeafType, inferenceContext)) {
                    toResolve = true;
                } else if (targetLeafType.isPrimitiveType() && (wrapper = inferenceContext.currentBounds.findWrapperTypeBound(alpha)) != null) {
                    toResolve = true;
                }
                if (toResolve) {
                    BoundSet solution = inferenceContext.solve(new InferenceVariable[]{alpha}, false);
                    if (solution == null) {
                        return false;
                    }
                    TypeBinding u = solution.getInstantiation(alpha, null).capture(inferenceContext.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    if (rTheta.dimensions() != 0) {
                        u = inferenceContext.environment.createArrayType(u, rTheta.dimensions());
                    }
                    ConstraintTypeFormula newConstraint4 = ConstraintTypeFormula.create(u, targetType, 1);
                    return inferenceContext.reduceAndIncorporate(newConstraint4);
                }
            }
            if (!inferenceContext.reduceAndIncorporate(newConstraint = ConstraintTypeFormula.create(rTheta, targetType, 1))) {
                return false;
            }
        }
        return true;
    }

    private static TypeBinding getRealErasure(TypeBinding type, LookupEnvironment environment) {
        TypeBinding erasure = type.erasure();
        TypeBinding erasedLeaf = erasure.leafComponentType();
        if (erasedLeaf.isGenericType()) {
            erasedLeaf = environment.convertToRawType(erasedLeaf, false);
        }
        if (erasure.isArrayType()) {
            return environment.createArrayType(erasedLeaf, erasure.dimensions());
        }
        return erasedLeaf;
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 context) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                LambdaExpression lambda = (LambdaExpression)this.left;
                ReferenceBinding targetType = (ReferenceBinding)this.right;
                ParameterizedTypeBinding withWildCards = InferenceContext18.parameterizedWithWildcard(targetType);
                if (withWildCards != null) {
                    targetType = ConstraintExpressionFormula.findGroundTargetType(context, lambda.enclosingScope, lambda, withWildCards);
                }
                if (targetType == null) {
                    return EMPTY_VARIABLE_LIST;
                }
                MethodBinding sam = targetType.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                if (lambda.argumentsTypeElided()) {
                    int len = sam.parameters.length;
                    int i = 0;
                    while (i < len) {
                        sam.parameters[i].collectInferenceVariables(variables);
                        ++i;
                    }
                }
                if (sam.returnType != TypeBinding.VOID) {
                    TypeBinding r = sam.returnType;
                    LambdaExpression resolved = lambda.resolveExpressionExpecting(this.right, context.scope);
                    Expression[] resultExpressions = resolved != null ? resolved.resultExpressions() : null;
                    int i = 0;
                    int length = resultExpressions == null ? 0 : resultExpressions.length;
                    while (i < length) {
                        variables.addAll(new ConstraintExpressionFormula(resultExpressions[i], r, 1).inputVariables(context));
                        ++i;
                    }
                }
                return variables;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope) && !this.left.isExactMethodReference()) {
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                int len = sam.parameters.length;
                int i = 0;
                while (i < len) {
                    sam.parameters[i].collectInferenceVariables(variables);
                    ++i;
                }
                return variables;
            }
        } else {
            SwitchExpression se;
            if (this.left instanceof ConditionalExpression && this.left.isPolyExpression()) {
                ConditionalExpression expr = (ConditionalExpression)this.left;
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                variables.addAll(new ConstraintExpressionFormula(expr.valueIfTrue, this.right, 1).inputVariables(context));
                variables.addAll(new ConstraintExpressionFormula(expr.valueIfFalse, this.right, 1).inputVariables(context));
                return variables;
            }
            Expression expression = this.left;
            if (expression instanceof SwitchExpression && (se = (SwitchExpression)expression).isPolyExpression()) {
                LinkedHashSet<InferenceVariable> variables = new LinkedHashSet<InferenceVariable>();
                for (Expression re : se.resultExpressions()) {
                    variables.addAll(new ConstraintExpressionFormula(re, this.right, 1).inputVariables(context));
                }
                return variables;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('\u27e8');
        this.left.printExpression(4, buf);
        buf.append(ConstraintExpressionFormula.relationToString(this.relation));
        this.appendTypeName(buf, this.right);
        buf.append('\u27e9');
        return buf.toString();
    }
}

