/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core;

import ch.epfl.scala.bsp4j.BuildClient;
import com.microsoft.java.bs.core.internal.gradle.GradleApiConnector;
import com.microsoft.java.bs.core.internal.log.LogHandler;
import com.microsoft.java.bs.core.internal.log.TelemetryHandler;
import com.microsoft.java.bs.core.internal.managers.BuildTargetManager;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.server.GradleBuildServer;
import com.microsoft.java.bs.core.internal.services.BuildTargetService;
import com.microsoft.java.bs.core.internal.services.LifecycleService;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class Launcher {
    public static final Logger LOGGER = Logger.getLogger("GradleBuildServerLogger");
    public static final String PROP_PLUGIN_DIR = "plugin.dir";

    public static void main(String[] args) {
        Launcher.checkRequiredProperties();
        org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> launcher = Launcher.createLauncher();
        Launcher.setupLoggers((BuildClient)launcher.getRemoteProxy());
        launcher.startListening();
    }

    private static org.eclipse.lsp4j.jsonrpc.Launcher<BuildClient> createLauncher() {
        BuildTargetManager buildTargetManager = new BuildTargetManager();
        PreferenceManager preferenceManager = new PreferenceManager();
        GradleApiConnector connector = new GradleApiConnector(preferenceManager);
        LifecycleService lifecycleService = new LifecycleService(connector, preferenceManager);
        BuildTargetService buildTargetService = new BuildTargetService(buildTargetManager, connector, preferenceManager);
        GradleBuildServer gradleBuildServer = new GradleBuildServer(lifecycleService, buildTargetService);
        org.eclipse.lsp4j.jsonrpc.Launcher launcher = new Launcher.Builder().setOutput((OutputStream)System.out).setInput(System.in).setLocalService((Object)gradleBuildServer).setRemoteInterface(BuildClient.class).setExecutorService(Executors.newCachedThreadPool()).create();
        buildTargetService.setClient((BuildClient)launcher.getRemoteProxy());
        return launcher;
    }

    private static void checkRequiredProperties() {
        if (System.getProperty(PROP_PLUGIN_DIR) == null) {
            throw new IllegalStateException("The property 'plugin.dir' is not set");
        }
    }

    private static void setupLoggers(BuildClient client) {
        LOGGER.setUseParentHandlers(false);
        LogHandler logHandler = new LogHandler(client);
        logHandler.setLevel(Level.FINE);
        LOGGER.addHandler(logHandler);
        if (System.getProperty("disableServerTelemetry") == null) {
            TelemetryHandler telemetryHandler = new TelemetryHandler(client);
            telemetryHandler.setLevel(Level.INFO);
            LOGGER.addHandler(telemetryHandler);
        }
    }
}

