/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.UsageDataStore;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class UsageDataLogHandler
extends Handler {
    Level thresholdLevel = Level.SEVERE;

    public UsageDataLogHandler(Level level) {
        this.thresholdLevel = level;
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() >= this.thresholdLevel.intValue()) {
            Object[] params;
            if (record.getThrown() != null) {
                if (UsageDataLogHandler.isUserError(record.getThrown())) {
                    return;
                }
                UsageDataStore.getInstance().logErrorData(record.getMessage(), record.getThrown());
                UsageDataSession.enableJdiEventSequence();
            } else if (record.getParameters() != null && (params = record.getParameters()).length == 1 && params[0].getClass() != null && Map.class.isAssignableFrom(params[0].getClass())) {
                UsageDataStore.getInstance().logSessionData(record.getMessage(), (Map)params[0]);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static boolean isUserError(Throwable th) {
        return th instanceof DebugException && ((DebugException)th).isUserError();
    }
}

