/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.EnumConstantDeclaration;
import com.sun.mirror.declaration.EnumDeclaration;
import com.sun.mirror.type.EnumType;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.TypeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.apt.core.internal.declaration.ClassDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class EnumDeclarationImpl
extends ClassDeclarationImpl
implements EnumDeclaration,
EnumType {
    public EnumDeclarationImpl(ITypeBinding binding, BaseProcessorEnv env) {
        super(binding, env);
        assert (binding.isEnum()) : "binding is not an enum.";
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitEnumDeclaration(this);
    }

    @Override
    public Collection<EnumConstantDeclaration> getEnumConstants() {
        ITypeBinding enumBinding = this.getDeclarationBinding();
        IVariableBinding[] fields = enumBinding.getDeclaredFields();
        ArrayList<EnumConstantDeclaration> results = new ArrayList<EnumConstantDeclaration>(4);
        IVariableBinding[] iVariableBindingArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            EclipseDeclarationImpl mirrorDecl;
            IVariableBinding field = iVariableBindingArray[n2];
            if (field.isEnumConstant() && (mirrorDecl = Factory.createDeclaration((IBinding)field, this._env)) != null) {
                results.add((EnumConstantDeclaration)((Object)mirrorDecl));
            }
            ++n2;
        }
        return results;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visitEnumType(this);
    }

    @Override
    public EnumDeclaration getDeclaration() {
        return (EnumDeclaration)super.getDeclaration();
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_ENUM;
    }
}

