/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import com.google.common.cache.Cache;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.buildship.core.internal.CachingBuildActionExecuter;
import org.eclipse.buildship.core.internal.CachingBuilder;
import org.eclipse.buildship.core.internal.CachingModelBuilder;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;

final class CachingProjectConnection
implements ProjectConnection {
    private final ProjectConnection delegate;
    private final Cache<Object, Object> cache;

    public CachingProjectConnection(ProjectConnection delegate, Cache<Object, Object> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    public <T> T getModel(Class<T> modelType) throws GradleConnectionException, IllegalStateException {
        return (T)this.model(modelType).get();
    }

    public <T> void getModel(Class<T> modelType, ResultHandler<? super T> handler) throws IllegalStateException {
        this.model(modelType).get(handler);
    }

    public BuildLauncher newBuild() {
        return this.delegate.newBuild();
    }

    public TestLauncher newTestLauncher() {
        return this.delegate.newTestLauncher();
    }

    public <T> ModelBuilder<T> model(Class<T> modelType) {
        return new CachingModelBuilder<T>(this.delegate.model(modelType), this.cache, modelType);
    }

    public <T> BuildActionExecuter<T> action(BuildAction<T> buildAction) {
        return new CachingBuildActionExecuter<T>(this.delegate.action(buildAction), buildAction, this.cache);
    }

    public BuildActionExecuter.Builder action() {
        return new CachingBuilder(this.delegate, this.cache);
    }

    public void close() {
        this.delegate.close();
    }

    public void notifyDaemonsAboutChangedPaths(List<Path> changedPaths) {
        this.delegate.notifyDaemonsAboutChangedPaths(changedPaths);
    }
}

