/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.core.BinaryMethod;

final class DOMCompletionEngineMethodDeclHandler {
    private DOMCompletionEngineMethodDeclHandler() {
    }

    public static List<String> findVariableNames(IMethodBinding binding) {
        IJavaElement iJavaElement = binding.getJavaElement();
        if (iJavaElement instanceof IMethod) {
            IMethod m = (IMethod)iJavaElement;
            try {
                BinaryMethod binary;
                IElementInfo iElementInfo;
                List<String> res = List.of(m.getParameterNames());
                if (!res.isEmpty() && m instanceof BinaryMethod && (iElementInfo = (binary = (BinaryMethod)m).getElementInfo()) instanceof MethodInfo) {
                    MethodInfo info = (MethodInfo)iElementInfo;
                    if (IntStream.range(0, res.size()).mapToObj(n -> "arg" + n).toList().equals(res) && (info.getArgumentNames() == null || info.getArgumentNames().length == 0)) {
                        return null;
                    }
                }
                return res;
            }
            catch (JavaModelException ex) {
                ILog.get().warn(ex.getMessage(), (Throwable)ex);
            }
        }
        if (binding.getDeclaringClass().isFromSource() || binding.getDeclaringClass().isArray()) {
            return List.of(binding.getParameterNames());
        }
        return null;
    }
}

