/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.dom;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.SignatureUtils;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LambdaExpression;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.core.LambdaUtils;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;

public class JavacLambdaBinding
extends JavacMethodBinding {
    private org.eclipse.jdt.core.dom.LambdaExpression declaration;
    private JCTree.JCLambda jcLambda;

    public JavacLambdaBinding(JavacMethodBinding methodBinding, org.eclipse.jdt.core.dom.LambdaExpression declaration, JCTree.JCLambda lambda) {
        super(methodBinding.methodType, methodBinding.methodSymbol, methodBinding.parentType, methodBinding.resolver);
        this.declaration = declaration;
        this.jcLambda = lambda;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) return false;
        if (!(obj instanceof JavacLambdaBinding)) return false;
        JavacLambdaBinding other = (JavacLambdaBinding)obj;
        if (!Objects.equals(other.declaration, this.declaration)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.declaration.hashCode();
    }

    @Override
    public int getModifiers() {
        return super.getModifiers() & 0xFFFFFBFF;
    }

    @Override
    public IBinding getDeclaringMember() {
        VariableDeclarationFragment fragment;
        ASTNode aSTNode = this.declaration.getParent();
        if (aSTNode instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)aSTNode).getParent() instanceof FieldDeclaration) {
            return fragment.resolveBinding();
        }
        for (ASTNode parent = this.declaration.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)parent;
                return method.resolveBinding();
            }
            if (!(parent instanceof org.eclipse.jdt.core.dom.LambdaExpression)) continue;
            org.eclipse.jdt.core.dom.LambdaExpression lambda = (org.eclipse.jdt.core.dom.LambdaExpression)parent;
            return lambda.resolveMethodBinding();
        }
        return null;
    }

    @Override
    public IMethod getJavaElement() {
        IJavaElement iJavaElement;
        IBinding member = this.getDeclaringMember();
        if (member != null && (iJavaElement = member.getJavaElement()) instanceof JavaElement) {
            JavaElement parent = (JavaElement)iJavaElement;
            int arrowIndex = this.declaration.parameters().stream().mapToInt(param -> param.getStartPosition() + param.getLength()).max().orElse(this.declaration.getStartPosition());
            LambdaExpression expr = LambdaFactory.createLambdaExpression((JavaElement)parent, (String)Signature.createTypeSignature((String)this.getMethodDeclaration().getDeclaringClass().getQualifiedName(), (boolean)true), (int)this.declaration.getStartPosition(), (int)(this.declaration.getStartPosition() + this.declaration.getLength() - 1), (int)arrowIndex);
            LambdaMethod lambdaMethod = LambdaFactory.createLambdaMethod((JavaElement)expr, (String)this.methodSymbol.name.toString(), (String)this.getKey(), (int)this.declaration.getStartPosition(), (int)(this.declaration.getStartPosition() + this.declaration.getLength() - 1), (int)arrowIndex, (String[])((String[])Arrays.stream(this.getParameterTypes()).map(SignatureUtils::getSignature).toArray(String[]::new)), (String[])this.getParameterNames(), (String)SignatureUtils.getSignature(this.getReturnType()));
            LambdaUtils.attachMethodToExpression(lambdaMethod, expr);
            ILocalVariable[] parameters = (ILocalVariable[])this.methodSymbol.params.stream().map(this.resolver.bindings::getVariableBinding).map(IBinding::getJavaElement).toArray(ILocalVariable[]::new);
            LambdaUtils.attachMethodArgumentsToLambda(lambdaMethod, parameters);
            return lambdaMethod;
        }
        return super.getJavaElement();
    }

    @Override
    public String[] getParameterNames() {
        return (String[])this.declaration.parameters().stream().map(VariableDeclaration::getName).map(SimpleName::getIdentifier).toArray(String[]::new);
    }

    @Override
    public ITypeBinding[] getParameterTypes() {
        ITypeBinding[] res = new ITypeBinding[this.methodType.getParameterTypes().size()];
        boolean allFound = false;
        if (this.jcLambda != null) {
            allFound = true;
            List<Type> paramTypes = this.jcLambda.params.stream().map(p -> p.sym.type).toList();
            for (int i = 0; i < res.length; ++i) {
                Type paramType = paramTypes.get(i);
                JavacTypeBinding paramBinding = this.resolver.bindings.getTypeBinding(paramType);
                if (paramBinding == null) {
                    allFound = false;
                }
                res[i] = paramBinding;
            }
        }
        if (!allFound) {
            for (int i = 0; i < res.length; ++i) {
                MethodDeclaration methodDecl;
                Object e;
                ASTNode aSTNode;
                Type paramType = (Type)this.methodType.getParameterTypes().get(i);
                JavacTypeBinding paramBinding = this.resolver.bindings.getTypeBinding(paramType);
                if (paramBinding == null && (aSTNode = this.resolver.findDeclaringNode((IBinding)this)) instanceof MethodDeclaration && (e = (methodDecl = (MethodDeclaration)aSTNode).parameters().get(i)) instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration paramDeclaration = (SingleVariableDeclaration)e;
                    paramBinding = this.resolver.resolveType(paramDeclaration.getType());
                }
                res[i] = paramBinding;
            }
        }
        return res;
    }
}

