/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockPreVisitor;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.html.Disposable;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderIdGenerator
implements HtmlIdGenerator,
Disposable {
    HashMap<String, Integer> headerBaseIds = new HashMap();
    boolean resolveDupes;
    String toDashChars;
    String nonDashChars;
    boolean noDupedDashes;
    boolean nonAsciiToLowercase;

    public HeaderIdGenerator() {
        this(null);
    }

    public HeaderIdGenerator(@Nullable DataHolder options) {
        this.resolveDupes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.get(options);
        this.toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.get(options);
        this.nonDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.get(options);
        this.noDupedDashes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.get(options);
        this.nonAsciiToLowercase = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE.get(options);
    }

    @Override
    public void dispose() {
        this.headerBaseIds = null;
    }

    public boolean isResolveDupes() {
        return this.resolveDupes;
    }

    public void setResolveDupes(boolean resolveDupes) {
        this.resolveDupes = resolveDupes;
    }

    public String getToDashChars() {
        return this.toDashChars;
    }

    public void setToDashChars(String toDashChars) {
        this.toDashChars = toDashChars;
    }

    public String getNonDashChars() {
        return this.nonDashChars;
    }

    public void setNonDashChars(String nonDashChars) {
        this.nonDashChars = nonDashChars;
    }

    public boolean isNoDupedDashes() {
        return this.noDupedDashes;
    }

    public void setNoDupedDashes(boolean noDupedDashes) {
        this.noDupedDashes = noDupedDashes;
    }

    public boolean isNonAsciiToLowercase() {
        return this.nonAsciiToLowercase;
    }

    public void setNonAsciiToLowercase(boolean nonAsciiToLowercase) {
        this.nonAsciiToLowercase = nonAsciiToLowercase;
    }

    @Override
    public void generateIds(@NotNull Document document) {
        this.generateIds(document, null);
    }

    @Override
    public void generateIds(Document document, final @Nullable AnchorRefTargetBlockPreVisitor preVisitor) {
        this.headerBaseIds.clear();
        this.resolveDupes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.get((DataHolder)document);
        this.toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.get((DataHolder)document);
        this.nonDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.get((DataHolder)document);
        this.noDupedDashes = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.get((DataHolder)document);
        this.nonAsciiToLowercase = (Boolean)HtmlRenderer.HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE.get((DataHolder)document);
        new AnchorRefTargetBlockVisitor(){

            @Override
            protected boolean preVisit(@NotNull Node node) {
                return preVisitor == null || preVisitor.preVisit(node, this);
            }

            @Override
            protected void visit(AnchorRefTarget node) {
                if (node.getAnchorRefId().isEmpty()) {
                    String text = node.getAnchorRefText();
                    String refId = null;
                    refId = HeaderIdGenerator.this.generateId(text);
                    if (refId != null) {
                        node.setAnchorRefId(refId);
                    }
                }
            }
        }.visit((Node)document);
    }

    String generateId(String text) {
        if (!text.isEmpty()) {
            Object baseRefId = HeaderIdGenerator.generateId(text, this.toDashChars, this.nonDashChars, this.noDupedDashes, this.nonAsciiToLowercase);
            if (this.resolveDupes) {
                if (this.headerBaseIds.containsKey(baseRefId)) {
                    int index = this.headerBaseIds.get(baseRefId);
                    this.headerBaseIds.put((String)baseRefId, ++index);
                    baseRefId = (String)baseRefId + "-" + index;
                } else {
                    this.headerBaseIds.put((String)baseRefId, 0);
                }
            }
            return baseRefId;
        }
        return null;
    }

    @Override
    @Nullable
    public String getId(@NotNull Node node) {
        return node instanceof AnchorRefTarget ? ((AnchorRefTarget)node).getAnchorRefId() : null;
    }

    @Override
    @Nullable
    public String getId(@NotNull CharSequence text) {
        return this.generateId(text.toString());
    }

    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes, boolean nonAsciiToLowercase) {
        return HeaderIdGenerator.generateId(headerText, toDashChars, null, noDupedDashes, nonAsciiToLowercase);
    }

    public static String generateId(CharSequence headerText, String toDashChars, String nonDashChars, boolean noDupedDashes, boolean nonAsciiToLowercase) {
        int iMax = headerText.length();
        StringBuilder baseRefId = new StringBuilder(iMax);
        if (toDashChars == null) {
            toDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.get(null);
        }
        if (nonDashChars == null) {
            nonDashChars = (String)HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.get(null);
        }
        for (int i = 0; i < iMax; ++i) {
            char c = headerText.charAt(i);
            if (HeaderIdGenerator.isAlphabetic(c)) {
                if (!(nonAsciiToLowercase || c >= 'A' && c <= 'Z')) {
                    baseRefId.append(c);
                    continue;
                }
                baseRefId.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isDigit(c)) {
                baseRefId.append(c);
                continue;
            }
            if (nonDashChars.indexOf(c) != -1) {
                baseRefId.append(c);
                continue;
            }
            if (toDashChars.indexOf(c) == -1 || noDupedDashes && (c != '-' || baseRefId.length() != 0) && (baseRefId.length() == 0 || baseRefId.charAt(baseRefId.length() - 1) == '-')) continue;
            baseRefId.append('-');
        }
        return baseRefId.toString();
    }

    public static boolean isAlphabetic(char c) {
        return (1086 >> Character.getType((int)c) & 1) != 0;
    }

    public static class Factory
    implements HeaderIdGeneratorFactory {
        @Override
        @NotNull
        public HeaderIdGenerator create(@NotNull LinkResolverContext context) {
            return new HeaderIdGenerator();
        }

        @Override
        @NotNull
        public HeaderIdGenerator create() {
            return new HeaderIdGenerator();
        }
    }
}

