/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtils;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;

class RelevanceUtils {
    RelevanceUtils() {
    }

    public static int computeRelevanceForCaseMatching(char[] token, char[] proposalName, AssistOptions options) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)false)) {
            if (CharOperation.prefixEquals((char[])token, (char[])proposalName, (boolean)true)) {
                return 10;
            }
        } else {
            if (options.camelCaseMatch && CharOperation.camelCaseMatch((char[])token, (char[])proposalName)) {
                return 5;
            }
            if (options.substringMatch && CharOperation.substringMatch((char[])token, (char[])proposalName)) {
                return -21;
            }
            if (options.subwordMatch && CharOperation.subWordMatch((char[])token, (char[])proposalName)) {
                return -22;
            }
        }
        return 0;
    }

    static int computeRelevanceForQualification(boolean prefixRequired, String prefix, String qualifiedPrefix) {
        boolean insideQualifiedReference;
        boolean bl = insideQualifiedReference = !prefix.equals(qualifiedPrefix);
        if (!prefixRequired && !insideQualifiedReference) {
            return 3;
        }
        if (prefixRequired && insideQualifiedReference) {
            return 2;
        }
        return 0;
    }

    static int computeRelevanceForExpectingType(ITypeBinding proposalType, ExpectedTypes expectedTypes) {
        if (proposalType != null) {
            int relevance = 0;
            if (!expectedTypes.getExpectedTypes().isEmpty() && PrimitiveType.VOID.toString().equals(proposalType.getName())) {
                return -5;
            }
            for (ITypeBinding expectedType : expectedTypes.getExpectedTypes()) {
                if (expectedTypes.allowsSubtypes() && proposalType.getErasure().isSubTypeCompatible(expectedType.getErasure())) {
                    if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                        return 30;
                    }
                    if (expectedType.isRawType() && Objects.equals(expectedType.getErasure().getQualifiedName(), proposalType.getErasure().getQualifiedName())) {
                        return 30;
                    }
                    if (proposalType.getPackage() != null && proposalType.getPackage().isUnnamed()) {
                        return 25;
                    }
                    relevance = 20;
                }
                if (expectedTypes.allowsSupertypes() && expectedType.isSubTypeCompatible(proposalType)) {
                    if (Objects.equals(expectedType.getQualifiedName(), proposalType.getQualifiedName())) {
                        return 30;
                    }
                    relevance = 20;
                }
                ITypeBinding oneErasure = expectedType.getErasure();
                ITypeBinding otherErasure = proposalType.getErasure();
                if ((oneErasure.isPrimitive() && otherErasure.getQualifiedName().startsWith("java.lang.") || otherErasure.isPrimitive() && oneErasure.getQualifiedName().startsWith("java.lang.")) && (oneErasure.getName().equalsIgnoreCase(otherErasure.getName()) || Set.of(oneErasure.getName().toLowerCase(), otherErasure.getName().toLowerCase()).equals(Set.of("char", "character")))) {
                    relevance = 20;
                }
                if (!"Ljava/lang/Object;".equals(expectedType.getKey()) || !proposalType.isPrimitive()) continue;
                relevance = 20;
            }
            return relevance;
        }
        return 0;
    }

    static int computeRelevanceForExpectingType(IType proposalType, ExpectedTypes expectedTypes, WorkingCopyOwner workingCopyOwner, Map<String, ITypeHierarchy> typeHierarchyCache) {
        if (proposalType != null) {
            IPackageFragment packageFragment = (IPackageFragment)proposalType.getAncestor(4);
            int relevance = 0;
            if (!expectedTypes.getExpectedTypes().isEmpty() && PrimitiveType.VOID.toString().equals(proposalType.getElementName())) {
                return -5;
            }
            for (ITypeBinding expectedType : expectedTypes.getExpectedTypes()) {
                ITypeBinding oneErasure;
                if (expectedTypes.allowsSubtypes() && DOMCompletionUtils.findInSupers(proposalType, expectedType.getKey(), workingCopyOwner, typeHierarchyCache)) {
                    if (expectedType.getKey().equals(proposalType.getKey())) {
                        return 30;
                    }
                    if (packageFragment != null && packageFragment.getElementName().equals("<default>")) {
                        return 25;
                    }
                    relevance = 20;
                }
                if (expectedTypes.allowsSupertypes() && DOMCompletionUtils.findInSupers(expectedType, proposalType.getKey())) {
                    if (expectedType.getKey().equals(proposalType.getKey())) {
                        return 30;
                    }
                    relevance = 20;
                }
                if (!(oneErasure = expectedType.getErasure()).isPrimitive() || !proposalType.getFullyQualifiedName().startsWith("java.lang.") || !oneErasure.getName().equalsIgnoreCase(proposalType.getElementName()) && !Set.of(oneErasure.getName().toLowerCase(), proposalType.getElementName().toLowerCase()).equals(Set.of("char", "character"))) continue;
                relevance = 20;
            }
            return relevance;
        }
        return 0;
    }

    static int simpleComputeRelevanceForExpectingType(IType type, ExpectedTypes expectedTypes) {
        return expectedTypes.getExpectedTypes().stream().map(ITypeBinding::getQualifiedName).anyMatch(type.getFullyQualifiedName()::equals) ? 30 : (expectedTypes.getExpectedTypes().stream().map(ITypeBinding::getQualifiedName).anyMatch(Object.class.getName()::equals) ? 20 : 0);
    }

    static int computeRelevanceForInheritance(ITypeBinding qualifyingType, IBinding member) {
        ITypeBinding typeBinding;
        IVariableBinding varBinding;
        IMethodBinding methodBinding;
        if (qualifyingType == null) {
            return 0;
        }
        if (member instanceof IMethodBinding ? (methodBinding = (IMethodBinding)member).getDeclaringClass().getKey().equals(qualifyingType.getKey()) : (member instanceof IVariableBinding ? (varBinding = (IVariableBinding)member).getDeclaringClass().getKey().equals(qualifyingType.getKey()) : member instanceof ITypeBinding && (typeBinding = (ITypeBinding)member).getDeclaringClass().getKey().equals(qualifyingType.getKey()))) {
            return 2;
        }
        return 0;
    }

    static int computeRelevanceForInheritance(ITypeBinding qualifyingType, IType memberType) {
        if (qualifyingType == null || memberType.getDeclaringType() == null) {
            return 0;
        }
        if (memberType.getDeclaringType().getKey().equals(qualifyingType.getKey())) {
            return 2;
        }
        return 0;
    }

    static int computeRelevanceForInteresting(IType potentiallyInterestingType, ExpectedTypes expectedTypes) {
        String typeKey = potentiallyInterestingType.getKey();
        for (ITypeBinding uninterestingType : expectedTypes.getUninterestingTypes()) {
            if (!uninterestingType.getKey().equals(typeKey)) continue;
            return 0;
        }
        return 5;
    }

    static int computeRelevanceForRestrictions(int accessRuleKind, Map<String, String> settings) {
        if (accessRuleKind == 0) {
            return 3;
        }
        if (accessRuleKind == 1 && settings.get("org.eclipse.jdt.core.compiler.problem.forbiddenReference").equals("ignore")) {
            return 3;
        }
        if (accessRuleKind == 2 && settings.get("org.eclipse.jdt.core.compiler.problem.discouragedReference").equals("ignore")) {
            return 3;
        }
        return 0;
    }
}

