/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.EnumSet;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTGotoStatement;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousStatement;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.DeclarationWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ProblemRuntimeException;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class StatementWriter
extends NodeWriter {
    private static final String DEFAULT = "default:";
    private static final String CASE = "case ";
    private static final String WHILE = "while (";
    private static final String TRY = "try ";
    private static final String CATCH = "catch (";
    private static final String RETURN = "return";
    private static final String GOTO = "goto ";
    private static final String CONTINUE = "continue";
    private static final String BREAK = "break";
    private static final String ELSE = "else";
    private static final String IF = "if ";
    private static final String CONSTEXPR = "constexpr ";
    private static final String FOR = "for (";
    private static final String DO_WHILE = " while (";
    private static final String DO = "do";
    private static final String SWITCH_BRACKET = "switch (";
    private boolean compoundNoNewLine = false;
    private boolean switchIsNew;
    private boolean decrementIndentationLevelOneMore = false;
    private final DeclarationWriter declWriter;

    public StatementWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
        this.declWriter = new DeclarationWriter(scribe, visitor, commentMap);
    }

    protected int writeStatement(IASTStatement statement, boolean newLine) {
        this.adaptIndentationLevel(statement);
        this.writeAttributes(statement);
        if (statement instanceof IASTAmbiguousStatement) {
            statement.accept(this.visitor);
            newLine = false;
        } else if (statement instanceof IASTExpressionStatement) {
            this.writeExpressionStatement((IASTExpressionStatement)statement);
        } else if (statement instanceof IASTDeclarationStatement) {
            this.writeDeclarationStatement((IASTDeclarationStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTNullStatement) {
            this.writeNullStatement((IASTNullStatement)statement);
        } else if (statement instanceof IASTReturnStatement) {
            this.writeReturnStatement((IASTReturnStatement)statement);
        } else if (statement instanceof IASTGotoStatement) {
            this.writeGotoStatement((IASTGotoStatement)statement);
        } else if (statement instanceof IGNUASTGotoStatement) {
            this.writeGNUASTGotoStatement((IGNUASTGotoStatement)statement);
        } else if (statement instanceof IASTLabelStatement) {
            this.writeLabelStatement((IASTLabelStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTCaseStatement) {
            this.writeCaseStatement((IASTCaseStatement)statement);
        } else if (statement instanceof IASTDefaultStatement) {
            this.writeDefaultStatement((IASTDefaultStatement)statement);
        } else if (statement instanceof IASTContinueStatement) {
            this.writeContinueStatement((IASTContinueStatement)statement);
        } else if (statement instanceof IASTCompoundStatement) {
            if (this.compoundNoNewLine) {
                newLine = false;
                this.compoundNoNewLine = false;
            }
            this.writeCompoundStatement((IASTCompoundStatement)statement);
        } else if (statement instanceof IASTBreakStatement) {
            this.writeBreakStatement((IASTBreakStatement)statement);
        } else if (statement instanceof IASTSwitchStatement) {
            this.writeSwitchStatement((IASTSwitchStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTIfStatement) {
            this.writeIfStatement((IASTIfStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTWhileStatement) {
            this.writeWhileStatement((IASTWhileStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTForStatement) {
            this.writeForStatement((IASTForStatement)statement);
            newLine = false;
        } else if (statement instanceof ICPPASTRangeBasedForStatement) {
            this.writeForStatement((ICPPASTRangeBasedForStatement)statement);
            newLine = false;
        } else if (statement instanceof IASTDoStatement) {
            this.writeDoStatement((IASTDoStatement)statement);
            newLine = true;
        } else if (statement instanceof ICPPASTTryBlockStatement) {
            this.writeTryBlockStatement((ICPPASTTryBlockStatement)statement);
            newLine = false;
        } else if (statement instanceof ICPPASTCatchHandler) {
            this.writeCatchHandler((ICPPASTCatchHandler)statement);
            newLine = false;
        } else if (statement instanceof IASTProblemStatement) {
            throw new ProblemRuntimeException((IASTProblemStatement)statement);
        }
        this.writeTrailingComments(statement, newLine);
        return 1;
    }

    private void writeDoStatement(IASTDoStatement doStatement) {
        this.nextCompoundNoNewLine();
        this.scribe.print(DO);
        this.writeBodyStatement(doStatement.getBody(), true);
        this.scribe.print(DO_WHILE);
        doStatement.getCondition().accept(this.visitor);
        this.scribe.print(')');
        this.scribe.printSemicolon();
    }

    private void writeForStatement(IASTForStatement forStatement) {
        this.scribe.noNewLines();
        this.scribe.print(FOR);
        this.writeStatement(forStatement.getInitializerStatement(), false);
        if (forStatement instanceof ICPPASTForStatement) {
            ICPPASTForStatement cppForStatment = (ICPPASTForStatement)forStatement;
            IASTDeclaration cppConditionDeclaration = cppForStatment.getConditionDeclaration();
            if (cppConditionDeclaration == null) {
                this.visitNodeIfNotNull(cppForStatment.getConditionExpression());
                this.scribe.printSemicolon();
            } else {
                cppConditionDeclaration.accept(this.visitor);
            }
        } else if (forStatement.getConditionExpression() != null) {
            forStatement.getConditionExpression().accept(this.visitor);
            this.scribe.printSemicolon();
        }
        this.visitNodeIfNotNull(forStatement.getIterationExpression());
        this.scribe.print(')');
        this.scribe.newLines();
        this.nextCompoundNoNewLine();
        this.writeBodyStatement(forStatement.getBody(), false);
    }

    private void writeForStatement(ICPPASTRangeBasedForStatement forStatment) {
        this.scribe.noNewLines();
        this.scribe.print(FOR);
        this.writeDeclarationWithoutSemicolon(forStatment.getDeclaration());
        this.scribe.print(": ");
        this.visitNodeIfNotNull(forStatment.getInitializerClause());
        this.scribe.print(')');
        this.scribe.newLines();
        this.nextCompoundNoNewLine();
        this.writeBodyStatement(forStatment.getBody(), false);
    }

    private void writeIfStatement(IASTIfStatement ifStatement) {
        this.scribe.print(IF);
        boolean isCPPIfStatement = ifStatement instanceof ICPPASTIfStatement;
        if (isCPPIfStatement && ((ICPPASTIfStatement)ifStatement).isConstexpr()) {
            this.scribe.print(CONSTEXPR);
        }
        this.scribe.print('(');
        this.scribe.noNewLines();
        if (isCPPIfStatement) {
            ICPPASTIfStatement cppIfStatment = (ICPPASTIfStatement)ifStatement;
            IASTStatement initStatement = cppIfStatment.getInitializerStatement();
            if (initStatement != null) {
                this.writeStatement(initStatement, false);
            }
            if (cppIfStatment.getConditionDeclaration() == null) {
                cppIfStatment.getConditionExpression().accept(this.visitor);
            } else {
                this.writeDeclarationWithoutSemicolon(cppIfStatment.getConditionDeclaration());
            }
        } else {
            ifStatement.getConditionExpression().accept(this.visitor);
        }
        this.scribe.print(')');
        this.scribe.newLines();
        this.nextCompoundNoNewLine();
        IASTStatement elseClause = ifStatement.getElseClause();
        this.writeBodyStatement(ifStatement.getThenClause(), elseClause != null);
        if (elseClause != null) {
            this.scribe.print(ELSE);
            this.nextCompoundNoNewLine();
            this.writeBodyStatement(elseClause, false);
        }
    }

    protected void writeDeclarationWithoutSemicolon(IASTDeclaration declaration) {
        this.declWriter.writeDeclaration(declaration, false);
    }

    private void writeBreakStatement(IASTBreakStatement statement) {
        this.scribe.print(BREAK);
        this.scribe.printSemicolon();
    }

    private void writeContinueStatement(IASTContinueStatement statement) {
        this.scribe.print(CONTINUE);
        this.scribe.printSemicolon();
    }

    private void writeLabelStatement(IASTLabelStatement labelStatement) {
        labelStatement.getName().accept(this.visitor);
        this.scribe.print(':');
        this.scribe.newLine();
        labelStatement.getNestedStatement().accept(this.visitor);
    }

    private void writeGotoStatement(IASTGotoStatement gotoStatement) {
        this.scribe.print(GOTO);
        gotoStatement.getName().accept(this.visitor);
        this.scribe.printSemicolon();
    }

    private void writeGNUASTGotoStatement(IGNUASTGotoStatement gotoStatement) {
        this.scribe.print(GOTO);
        gotoStatement.getLabelNameExpression().accept(this.visitor);
        this.scribe.printSemicolon();
    }

    private void writeReturnStatement(IASTReturnStatement returnStatement) {
        this.scribe.noNewLines();
        this.scribe.print(RETURN);
        IASTExpression returnValue = returnStatement.getReturnValue();
        if (returnValue != null) {
            this.scribe.printSpaces(1);
            returnValue.accept(this.visitor);
        }
        this.scribe.newLines();
        this.scribe.printSemicolon();
    }

    private void writeNullStatement(IASTNullStatement nullStmt) {
        this.scribe.printSemicolon();
    }

    private void writeDeclarationStatement(IASTDeclarationStatement decStmt) {
        decStmt.getDeclaration().accept(this.visitor);
    }

    private void writeExpressionStatement(IASTExpressionStatement expStmt) {
        expStmt.getExpression().accept(this.visitor);
        this.scribe.printSemicolon();
    }

    private void writeCatchHandler(ICPPASTCatchHandler catchStatement) {
        this.scribe.print(CATCH);
        if (catchStatement.isCatchAll()) {
            this.scribe.print("...");
        } else {
            this.scribe.noSemicolon();
            this.scribe.noNewLines();
            catchStatement.getDeclaration().accept(this.visitor);
            this.scribe.newLines();
        }
        this.scribe.print(')');
        this.writeBodyStatement(catchStatement.getCatchBody(), true);
    }

    private void writeTryBlockStatement(ICPPASTTryBlockStatement tryStatement) {
        this.scribe.print(TRY);
        tryStatement.getTryBody().accept(this.visitor);
        ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = tryStatement.getCatchHandlers();
        int n = iCPPASTCatchHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCatchHandler catchStatement = iCPPASTCatchHandlerArray[n2];
            this.writeStatement(catchStatement, false);
            ++n2;
        }
    }

    private void writeWhileStatement(IASTWhileStatement whileStatment) {
        this.scribe.print(WHILE);
        this.scribe.noNewLines();
        if (whileStatment instanceof ICPPASTWhileStatement) {
            ICPPASTWhileStatement cppWhileStatment = (ICPPASTWhileStatement)whileStatment;
            if (cppWhileStatment.getConditionDeclaration() == null) {
                cppWhileStatment.getCondition().accept(this.visitor);
            } else {
                this.writeDeclarationWithoutSemicolon(cppWhileStatment.getConditionDeclaration());
            }
        } else {
            whileStatment.getCondition().accept(this.visitor);
        }
        this.scribe.print(')');
        this.scribe.newLines();
        this.nextCompoundNoNewLine();
        this.writeBodyStatement(whileStatment.getBody(), false);
    }

    private void writeCaseStatement(IASTCaseStatement caseStatement) {
        this.scribe.print(CASE);
        caseStatement.getExpression().accept(this.visitor);
        this.scribe.print(':');
        this.scribe.incrementIndentationLevel();
        this.switchIsNew = false;
    }

    private void writeSwitchStatement(IASTSwitchStatement switchStatement) {
        this.switchIsNew = true;
        this.scribe.print(SWITCH_BRACKET);
        this.scribe.noNewLines();
        if (switchStatement instanceof ICPPASTSwitchStatement) {
            ICPPASTSwitchStatement cppSwitchStatement = (ICPPASTSwitchStatement)switchStatement;
            IASTStatement initStatement = cppSwitchStatement.getInitializerStatement();
            if (initStatement != null) {
                this.writeStatement(initStatement, false);
            }
            if (cppSwitchStatement.getControllerDeclaration() == null) {
                cppSwitchStatement.getControllerExpression().accept(this.visitor);
            } else {
                this.declWriter.writeDeclaration(cppSwitchStatement.getControllerDeclaration(), false);
            }
        } else {
            switchStatement.getControllerExpression().accept(this.visitor);
        }
        this.scribe.print(')');
        this.scribe.newLines();
        this.nextCompoundNoNewLine();
        this.writeBodyStatement(switchStatement.getBody(), false);
        this.switchIsNew = false;
    }

    private void writeDefaultStatement(IASTDefaultStatement defaultStatement) {
        this.scribe.print(DEFAULT);
        this.scribe.incrementIndentationLevel();
        this.switchIsNew = false;
    }

    private void writeCompoundStatement(IASTCompoundStatement compoundStatement) {
        this.scribe.printLBrace();
        this.scribe.newLine();
        IASTStatement[] iASTStatementArray = this.getNestedStatements(compoundStatement);
        int n = iASTStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statements = iASTStatementArray[n2];
            statements.accept(this.visitor);
            ++n2;
        }
        if (this.hasFreestandingComments(compoundStatement)) {
            this.writeFreestandingComments(compoundStatement);
        }
        if (this.decrementIndentationLevelOneMore) {
            this.scribe.decrementIndentationLevel();
            this.decrementIndentationLevelOneMore = false;
        }
        this.scribe.printRBrace();
    }

    protected IASTStatement[] getNestedStatements(IASTCompoundStatement compoundStatement) {
        return compoundStatement.getStatements();
    }

    protected void writeBodyStatement(IASTStatement statement, boolean isDoStatement) {
        if (statement instanceof IASTCompoundStatement) {
            statement.accept(this.visitor);
            if (!isDoStatement) {
                this.scribe.newLine();
            }
            this.compoundNoNewLine = false;
        } else if (statement instanceof IASTNullStatement) {
            statement.accept(this.visitor);
            this.scribe.newLine();
        } else {
            this.scribe.incrementIndentationLevel();
            this.scribe.newLine();
            statement.accept(this.visitor);
            this.scribe.decrementIndentationLevel();
        }
    }

    protected void nextCompoundNoNewLine() {
        this.compoundNoNewLine = true;
    }

    protected void nextCompoundIndentationLevelOneMore() {
        this.decrementIndentationLevelOneMore = true;
    }

    protected int writeMixedStatement(IASTStatement statement) {
        String code = statement.getRawSignature();
        this.scribe.println(code);
        return 1;
    }

    protected EnumSet<NodeWriter.SpaceLocation> spaceLocationForStatement(IASTStatement attributeOwner) {
        if (attributeOwner instanceof IASTNullStatement) {
            return EnumSet.noneOf(NodeWriter.SpaceLocation.class);
        }
        return EnumSet.of(NodeWriter.SpaceLocation.AFTER);
    }

    protected void writeAttributes(IASTStatement attributeOwner) {
        if (this.statementCanHaveAttributes(attributeOwner)) {
            EnumSet<NodeWriter.SpaceLocation> spaceLocation = this.spaceLocationForStatement(attributeOwner);
            this.writeAttributes(attributeOwner, spaceLocation);
        }
    }

    protected boolean statementCanHaveAttributes(IASTStatement attributeOwner) {
        return !(attributeOwner instanceof IASTDeclarationStatement) && !(attributeOwner instanceof ICPPASTCatchHandler);
    }

    protected void adaptIndentationLevel(IASTStatement statement) {
        if (this.isSwitchLabel(statement)) {
            this.nextCompoundIndentationLevelOneMore();
            if (!this.switchIsNew) {
                this.scribe.decrementIndentationLevel();
            }
        }
    }

    private boolean isSwitchLabel(IASTStatement statement) {
        return statement instanceof IASTDefaultStatement || statement instanceof IASTCaseStatement;
    }
}

