/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.cdt.managedbuilder.core.BuildListComparator;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IModificationStatus;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolChainEditTab;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ToolSelectionDialog
extends Dialog {
    private static final Image IMG_ARROW = CDTSharedImages.getImage((String)"icons/obj16/tc_preferred.gif");
    private static final String EMPTY_STR = "";
    private static final int COL_WIDTH = 300;
    private static Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    private static Color red = Display.getDefault().getSystemColor(3);
    private static Color gray = Display.getDefault().getSystemColor(16);
    private Table t1;
    private Table t2;
    private Button b_add;
    private Button b_del;
    private Button b_rep;
    private Button b_all;
    private CLabel errorLabel;
    private CLabel l1;
    private Text txt2;
    private ArrayList<ITool> left;
    private ArrayList<ITool> right;
    public ArrayList<ITool> added;
    public ArrayList<ITool> removed;
    public ITool[] all;
    public ITool[] used;
    public IFolderInfo fi;
    public IToolListModification mod = null;

    public ToolSelectionDialog(Shell shell, IResourceInfo ri) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ToolSelectionDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        composite.setLayoutData((Object)gd);
        this.added = new ArrayList();
        this.removed = new ArrayList();
        this.left = new ArrayList();
        this.right = new ArrayList();
        Composite c1 = new Composite(composite, 0);
        c1.setLayoutData((Object)new GridData(1808));
        c1.setLayout((Layout)new GridLayout(1, false));
        Composite c2 = new Composite(composite, 2048);
        c2.setLayoutData((Object)new GridData(1040));
        c2.setLayout((Layout)new GridLayout(1, false));
        Composite c3 = new Composite(composite, 0);
        c3.setLayoutData((Object)new GridData(1808));
        c3.setLayout((Layout)new GridLayout(1, false));
        this.t1 = new Table(c1, 2816);
        gd = new GridData(1808);
        this.t1.setLayoutData((Object)gd);
        this.t1.setHeaderVisible(true);
        this.t1.setLinesVisible(true);
        this.t1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleReplace();
            }

            public void widgetSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleSelection();
            }
        });
        TableColumn col = new TableColumn(this.t1, 0);
        col.setText(Messages.ToolSelectionDialog_1);
        col.setWidth(300);
        this.l1 = new CLabel(c1, 2048);
        this.l1.setLayoutData((Object)new GridData(768));
        this.t2 = new Table(c3, 2816);
        this.t2.setLayoutData((Object)new GridData(1808));
        this.t2.setHeaderVisible(true);
        this.t2.setLinesVisible(true);
        this.t2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleReplace();
            }

            public void widgetSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleSelection();
            }
        });
        col = new TableColumn(this.t2, 0);
        col.setText(Messages.ToolSelectionDialog_2);
        col.setWidth(300);
        this.txt2 = new Text(c3, 2890);
        gd = new GridData(1808);
        gd.verticalSpan = 2;
        gd.minimumHeight = 100;
        this.txt2.setLayoutData((Object)gd);
        this.b_add = new Button(c2, 8);
        this.b_add.setText(Messages.ToolSelectionDialog_12);
        this.b_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = ToolSelectionDialog.this.t1.getSelectionIndex();
                if (x == -1) {
                    return;
                }
                ITool tool = (ITool)ToolSelectionDialog.this.t1.getItem(x).getData();
                ToolSelectionDialog.this.left.remove(tool);
                ToolSelectionDialog.this.right.add(tool);
                ToolSelectionDialog.this.mod.changeProjectTools(null, tool);
                ToolSelectionDialog.this.updateData();
            }
        });
        this.b_add.setLayoutData((Object)new GridData(4, 1, true, false));
        this.b_rep = new Button(c2, 8);
        this.b_rep.setText(Messages.ToolSelectionDialog_14);
        this.b_rep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleReplace();
            }
        });
        this.b_rep.setLayoutData((Object)new GridData(4, 1, true, false));
        this.b_del = new Button(c2, 8);
        this.b_del.setText(Messages.ToolSelectionDialog_13);
        this.b_del.setLayoutData((Object)new GridData(768));
        this.b_del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int x = ToolSelectionDialog.this.t2.getSelectionIndex();
                if (x == -1) {
                    return;
                }
                ITool tool = (ITool)ToolSelectionDialog.this.t2.getItem(x).getData();
                ToolSelectionDialog.this.right.remove(tool);
                ToolSelectionDialog.this.left.add(ManagedBuildManager.getRealTool((ITool)tool));
                ToolSelectionDialog.this.mod.changeProjectTools(tool, null);
                ToolSelectionDialog.this.updateData();
            }
        });
        this.b_del.setLayoutData((Object)new GridData(4, 1, true, false));
        new Label(c2, 0).setLayoutData((Object)new GridData(4, 4, true, true));
        this.b_all = new Button(c2, 96);
        this.b_all.setText(Messages.ToolSelectionDialog_15);
        this.b_all.setLayoutData((Object)new GridData(768));
        this.b_all.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolSelectionDialog.this.handleSelection();
            }
        });
        this.b_all.setLayoutData((Object)new GridData(4, 0x1000008, true, false));
        this.errorLabel = new CLabel(composite, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.errorLabel.setLayoutData((Object)gd);
        this.errorLabel.setForeground(red);
        this.used = this.fi.getTools();
        int i = 0;
        while (i < this.used.length) {
            this.right.add(this.used[i]);
            int j = 0;
            while (j < this.all.length) {
                if (this.all[j] != null && this.all[j].matches(this.used[i])) {
                    this.all[j] = null;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.all.length) {
            if (this.all[j] != null) {
                this.left.add(this.all[j]);
            }
            ++j;
        }
        this.updateData();
        return composite;
    }

    private void handleReplace() {
        if (!this.b_rep.isEnabled()) {
            return;
        }
        int x1 = this.t1.getSelectionIndex();
        int x2 = this.t2.getSelectionIndex();
        if (x1 == -1 || x2 == -1) {
            return;
        }
        ITool tool1 = (ITool)this.t1.getItem(x1).getData();
        ITool tool2 = (ITool)this.t2.getItem(x2).getData();
        this.left.remove(tool1);
        this.right.add(tool1);
        this.right.remove(tool2);
        this.left.add(ManagedBuildManager.getRealTool((ITool)tool2));
        this.mod.changeProjectTools(tool2, tool1);
        this.updateData();
    }

    private void removeArrows(Table t) {
        int j = 0;
        while (j < t.getItemCount()) {
            TableItem ti = t.getItem(j);
            if (IMG_ARROW.equals((Object)ti.getImage())) {
                ti.setImage(null);
            }
            ++j;
        }
    }

    private void markReplace(Table src, Table dst, Button b) {
        int x = src.getSelectionIndex();
        if (x == -1) {
            return;
        }
        ITool tool = (ITool)src.getItem(x).getData();
        IToolModification tm = this.mod.getToolModification(tool);
        if (tm == null) {
            return;
        }
        IModificationOperation[] mo = tm.getSupportedOperations();
        if (mo == null || mo.length == 0) {
            return;
        }
        int j = 0;
        while (j < dst.getItemCount()) {
            TableItem ti = dst.getItem(j);
            ITool tt = (ITool)ti.getData();
            int i = 0;
            while (i < mo.length) {
                ITool t = mo[i].getReplacementTool();
                if (t == null) {
                    b.setEnabled(true);
                } else if (t.matches(tt)) {
                    ti.setImage(IMG_ARROW);
                    break;
                }
                ++i;
            }
            ++j;
        }
    }

    private void handleSelection() {
        this.removeArrows(this.t1);
        this.removeArrows(this.t2);
        this.b_add.setEnabled(this.b_all.getSelection() && this.t1.getItemCount() > 0);
        this.b_rep.setEnabled(this.b_all.getSelection() && this.t1.getItemCount() > 0 && this.t2.getItemCount() > 0);
        this.b_del.setEnabled(this.b_all.getSelection() && this.t2.getItemCount() > 0);
        if (this.t1.isFocusControl()) {
            this.markReplace(this.t1, this.t2, this.b_add);
            int j = this.adjustPosition(this.t2);
            this.markReplace(this.t2, this.t1, this.b_del);
            if (j != -1) {
                this.b_rep.setEnabled(true);
            }
        } else {
            this.markReplace(this.t2, this.t1, this.b_del);
            int j = this.adjustPosition(this.t1);
            this.markReplace(this.t1, this.t2, this.b_add);
            if (j != -1) {
                this.b_rep.setEnabled(true);
            }
        }
        this.showErrorMessage(this.t1, false);
        this.showErrorMessage(this.t2, true);
    }

    private int adjustPosition(Table t) {
        int j = t.getSelectionIndex();
        TableItem ti = t.getItem(j);
        if (IMG_ARROW.equals((Object)ti.getImage())) {
            return j;
        }
        j = 0;
        while (j < t.getItemCount()) {
            ti = t.getItem(j);
            if (IMG_ARROW.equals((Object)ti.getImage())) {
                t.select(j);
                return j;
            }
            ++j;
        }
        return -1;
    }

    private void showErrorMessage(Table t, boolean isPrj) {
        int x = t.getSelectionIndex();
        if (isPrj) {
            this.txt2.setText(EMPTY_STR);
        } else {
            this.l1.setText(EMPTY_STR);
            this.l1.setImage(null);
        }
        if (x == -1) {
            return;
        }
        Object message = EMPTY_STR;
        Image image = null;
        TableItem ti = t.getItem(x);
        ITool tool = (ITool)ti.getData();
        IToolModification tm = this.mod.getToolModification(tool);
        if (tm == null || tm.isCompatible()) {
            TableItem[] tis;
            if (IMG_ARROW.equals((Object)ti.getImage()) && !isPrj && (tis = this.t2.getSelection()) != null && tis.length > 0) {
                message = Messages.ToolSelectionDialog_16 + ((ITool)tis[0].getData()).getUniqueRealName();
            }
        } else {
            CompatibilityStatus cs = tm.getCompatibilityStatus();
            if (isPrj) {
                message = ToolChainEditTab.getCompatibilityMessage(cs);
            }
        }
        if (isPrj) {
            this.txt2.setText((String)message);
        } else {
            this.l1.setText((String)message);
            this.l1.setImage(image);
        }
    }

    private void add(ITool tool, Table table, boolean bold) {
        IToolModification tm = this.mod.getToolModification(tool);
        TableItem ti = new TableItem(table, 0);
        ti.setText(tool.getUniqueRealName());
        if (bold) {
            ti.setFont(boldFont);
        }
        ti.setData((Object)tool);
        if (tm != null && !tm.isCompatible()) {
            ti.setForeground(table.equals(this.t2) ? red : gray);
        }
    }

    private void updateData() {
        int i;
        boolean exists;
        this.removed.clear();
        this.added.clear();
        int t1_pos = this.t1.getSelectionIndex();
        int t2_pos = this.t2.getSelectionIndex();
        this.t1.removeAll();
        this.t2.removeAll();
        Collections.sort(this.left, BuildListComparator.getInstance());
        for (ITool t : this.left) {
            exists = false;
            i = 0;
            while (i < this.all.length) {
                if (this.all[i] != null && t.matches(this.all[i])) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.removed.add(t);
            }
            this.add(t, this.t1, !exists);
        }
        for (ITool t : this.right) {
            exists = false;
            i = 0;
            while (i < this.used.length) {
                if (t.matches(this.used[i])) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.added.add(t);
            }
            this.add(t, this.t2, !exists);
        }
        IModificationStatus st = this.fi.getToolChainModificationStatus(this.removed.toArray(new ITool[this.removed.size()]), this.added.toArray(new ITool[this.added.size()]));
        if (st.isOK()) {
            this.errorLabel.setText(EMPTY_STR);
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
        } else {
            int c = st.getCode();
            Object s = EMPTY_STR;
            if ((c & 1) != 0) {
                s = (String)s + Messages.ToolSelectionDialog_7;
                ITool[][] tools = st.getToolsConflicts();
                ArrayList<String> conflictTools = new ArrayList<String>();
                int k = 0;
                while (k < this.t2.getItemCount()) {
                    TableItem ti = this.t2.getItem(k);
                    ITool t = (ITool)ti.getData();
                    int i2 = 0;
                    block5: while (i2 < tools.length) {
                        int j = 0;
                        while (j < tools[i2].length) {
                            if (t.matches(tools[i2][j])) {
                                conflictTools.add(ti.getText());
                                ti.setForeground(red);
                                break block5;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    ++k;
                }
                Iterator iterator = conflictTools.iterator();
                s = (String)s + " " + (String)iterator.next();
                while (iterator.hasNext()) {
                    s = (String)s + ", " + (String)iterator.next();
                }
            }
            if ((c & 0x10) != 0) {
                s = (String)s + Messages.ToolSelectionDialog_8;
                ITool[] tools = st.getNonManagedBuildTools();
                int k = 0;
                while (k < this.t2.getItemCount()) {
                    TableItem ti = this.t2.getItem(k);
                    ITool t = (ITool)ti.getData();
                    int i3 = 0;
                    while (i3 < tools.length) {
                        if (t.matches(tools[i3])) break;
                        ++i3;
                    }
                    ++k;
                }
            }
            if ((c & 8) != 0) {
                s = (String)s + Messages.ToolSelectionDialog_9;
            }
            if ((c & 2) != 0) {
                s = (String)s + Messages.ToolSelectionDialog_10;
            }
            if ((c & 4) != 0) {
                s = (String)s + Messages.ToolSelectionDialog_11;
            }
            this.errorLabel.setText((String)s);
        }
        if (t1_pos > -1 && t1_pos < this.t1.getItemCount()) {
            this.t1.select(t1_pos);
        } else if (this.t1.getItemCount() > 0) {
            this.t1.select(0);
        }
        if (t2_pos > -1 && t2_pos < this.t2.getItemCount()) {
            this.t2.select(t2_pos);
        } else if (this.t2.getItemCount() > 0) {
            this.t2.select(0);
        }
        this.handleSelection();
    }
}

