/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.Wire;

public class ConnectionCommand
extends Command {
    protected LogicSubpart oldSource;
    protected String oldSourceTerminal;
    protected LogicSubpart oldTarget;
    protected String oldTargetTerminal;
    protected LogicSubpart source;
    protected String sourceTerminal;
    protected LogicSubpart target;
    protected String targetTerminal;
    protected Wire wire;

    public ConnectionCommand() {
        super(LogicMessages.ConnectionCommand_Label);
    }

    public boolean canExecute() {
        if (this.target != null) {
            for (Wire conn : this.target.getConnections()) {
                if (this.targetTerminal == null || conn.getTargetTerminal() == null || !conn.getTargetTerminal().equals(this.targetTerminal) || !conn.getTarget().equals(this.target)) continue;
                return false;
            }
        }
        return true;
    }

    public void execute() {
        if (this.source != null) {
            this.wire.detachSource();
            this.wire.setSource(this.source);
            this.wire.setSourceTerminal(this.sourceTerminal);
            this.wire.attachSource();
        }
        if (this.target != null) {
            this.wire.detachTarget();
            this.wire.setTarget(this.target);
            this.wire.setTargetTerminal(this.targetTerminal);
            this.wire.attachTarget();
        }
        if (this.source == null && this.target == null) {
            this.wire.detachSource();
            this.wire.detachTarget();
            this.wire.setTarget(null);
            this.wire.setSource(null);
        }
    }

    public String getLabel() {
        return LogicMessages.ConnectionCommand_Description;
    }

    public LogicSubpart getSource() {
        return this.source;
    }

    public String getSourceTerminal() {
        return this.sourceTerminal;
    }

    public LogicSubpart getTarget() {
        return this.target;
    }

    public String getTargetTerminal() {
        return this.targetTerminal;
    }

    public Wire getWire() {
        return this.wire;
    }

    public void redo() {
        this.execute();
    }

    public void setSource(LogicSubpart newSource) {
        this.source = newSource;
    }

    public void setSourceTerminal(String newSourceTerminal) {
        this.sourceTerminal = newSourceTerminal;
    }

    public void setTarget(LogicSubpart newTarget) {
        this.target = newTarget;
    }

    public void setTargetTerminal(String newTargetTerminal) {
        this.targetTerminal = newTargetTerminal;
    }

    public void setWire(Wire w) {
        this.wire = w;
        this.oldSource = w.getSource();
        this.oldTarget = w.getTarget();
        this.oldSourceTerminal = w.getSourceTerminal();
        this.oldTargetTerminal = w.getTargetTerminal();
    }

    public void undo() {
        this.source = this.wire.getSource();
        this.target = this.wire.getTarget();
        this.sourceTerminal = this.wire.getSourceTerminal();
        this.targetTerminal = this.wire.getTargetTerminal();
        this.wire.detachSource();
        this.wire.detachTarget();
        this.wire.setSource(this.oldSource);
        this.wire.setTarget(this.oldTarget);
        this.wire.setSourceTerminal(this.oldSourceTerminal);
        this.wire.setTargetTerminal(this.oldTargetTerminal);
        this.wire.attachSource();
        this.wire.attachTarget();
    }
}

