/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.actions;

import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.LogicPlugin;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class IncrementDecrementAction
extends SelectionAction {
    private static final String INCREMENT_REQUEST = "Increment";
    private static final String DECREMENT_REQUEST = "Decrement";
    public static final String INCREMENT = "Increment";
    public static final String DECREMENT = "Decrement";
    Request request;

    public IncrementDecrementAction(IWorkbenchPart part, boolean increment) {
        super(part);
        if (increment) {
            this.request = new Request((Object)"Increment");
            this.setText(LogicMessages.IncrementDecrementAction_Increment_ActionLabelText);
            this.setId("Increment");
            this.setToolTipText(LogicMessages.IncrementDecrementAction_Increment_ActionToolTipText);
            this.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/plus.gif"));
        } else {
            this.request = new Request((Object)"Decrement");
            this.setText(LogicMessages.IncrementDecrementAction_Decrement_ActionLabelText);
            this.setId("Decrement");
            this.setToolTipText(LogicMessages.IncrementDecrementAction_Decrement_ActionToolTipText);
            this.setImageDescriptor(ImageDescriptor.createFromFile(LogicPlugin.class, (String)"icons/minus.gif"));
        }
        this.setHoverImageDescriptor(this.getImageDescriptor());
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        List selectedEditParts = this.getSelectedEditParts();
        if (selectedEditParts.isEmpty()) {
            return false;
        }
        return selectedEditParts.stream().allMatch(ep -> ep.getModel() instanceof LED);
    }

    private Command getCommand() {
        CompoundCommand cc = new CompoundCommand();
        cc.setDebugLabel("Increment/Decrement LEDs");
        this.getSelectedEditParts().stream().map(ep -> ep.getCommand(this.request)).forEach(arg_0 -> ((CompoundCommand)cc).add(arg_0));
        return cc;
    }

    public void run() {
        this.execute(this.getCommand());
    }
}

