/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.exampleStructures;

import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;

public class SimpleRelationship
implements ConnectionLayout {
    private static int DEFAULT_REL_LINE_WIDTH = 1;
    private static int DEFAULT_REL_LINE_WIDTH_SELECTED = DEFAULT_REL_LINE_WIDTH + 2;
    private static Object DEFAULT_RELATIONSHIP_COLOR;
    private static Object DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR;
    private int lineWidth = DEFAULT_REL_LINE_WIDTH;
    private Object color = DEFAULT_RELATIONSHIP_COLOR;
    protected SimpleNode sourceEntity;
    protected SimpleNode destinationEntity;
    protected boolean bidirectional;
    private double weight;
    private boolean visible;

    public SimpleRelationship(SimpleNode sourceEntity, SimpleNode destinationEntity, boolean bidirectional) {
        this(sourceEntity, destinationEntity, bidirectional, 1.0);
    }

    public SimpleRelationship(SimpleNode sourceEntity, SimpleNode destinationEntity, boolean bidirectional, double weight) {
        this.destinationEntity = destinationEntity;
        this.sourceEntity = sourceEntity;
        this.bidirectional = bidirectional;
        this.weight = weight;
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
        this.color = DEFAULT_RELATIONSHIP_COLOR;
    }

    public SimpleNode getSource() {
        return this.sourceEntity;
    }

    public SimpleNode getTarget() {
        return this.destinationEntity;
    }

    public boolean isDirected() {
        return this.bidirectional;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        String arrow = this.isDirected() ? " <-> " : " -> ";
        return "(" + String.valueOf(this.sourceEntity) + arrow + String.valueOf(this.destinationEntity) + ")";
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void resetLineWidth() {
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
    }

    public static void setDefaultSize(int i) {
        DEFAULT_REL_LINE_WIDTH = i;
        DEFAULT_REL_LINE_WIDTH_SELECTED = DEFAULT_REL_LINE_WIDTH + 2;
    }

    public void setSelected() {
        this.color = DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR;
        this.lineWidth = DEFAULT_REL_LINE_WIDTH_SELECTED;
    }

    public void setUnSelected() {
        this.color = DEFAULT_RELATIONSHIP_COLOR;
        this.lineWidth = DEFAULT_REL_LINE_WIDTH;
    }

    public Object getColor() {
        return this.color;
    }

    public void setColor(Object c) {
        this.color = c;
    }

    public static void setDefaultColor(Object c) {
        DEFAULT_RELATIONSHIP_COLOR = c;
    }

    public static void setDefaultHighlightColor(Object c) {
        DEFAULT_RELATIONSHIP_HIGHLIGHT_COLOR = c;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

