/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagramFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class LogicWizardPage1
extends WizardNewFileCreationPage
implements SelectionListener {
    private final IWorkbench workbench;
    private static int exampleCount = 1;
    private Button model1 = null;
    private Button model2 = null;
    private int modelSelected = 1;

    public LogicWizardPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("sampleLogicPage1", selection);
        this.setTitle(LogicMessages.CreateLogicPage1_Title);
        this.setDescription(LogicMessages.CreateLogicPage1_Description);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"icons/logicbanner.gif"));
        this.workbench = aWorkbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName("emptyModel" + exampleCount + ".logic");
        Composite composite = (Composite)this.getControl();
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(LogicMessages.CreateLogicPage1_ModelNames_GroupName);
        group.setLayoutData((Object)new GridData(768));
        this.model1 = new Button((Composite)group, 16);
        this.model1.setText(LogicMessages.CreateLogicPage1_ModelNames_EmptyModelName);
        this.model1.addSelectionListener((SelectionListener)this);
        this.model1.setSelection(true);
        this.model2 = new Button((Composite)group, 16);
        this.model2.setText(LogicMessages.CreateLogicPage1_ModelNames_FourBitAdderModelName);
        this.model2.addSelectionListener((SelectionListener)this);
        new Label(composite, 0);
        this.setPageComplete(this.validatePage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InputStream getInitialContents() {
        LogicDiagram ld = new LogicDiagram();
        if (this.modelSelected == 2) {
            ld = (LogicDiagram)LogicDiagramFactory.createLargeModel();
        }
        ByteArrayInputStream bais = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                        oos.writeObject(ld);
                        oos.flush();
                        bais = new ByteArrayInputStream(baos.toByteArray());
                        bais.close();
                    }
                    if (baos == null) return bais;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (baos == null) throw throwable;
                    baos.close();
                    throw throwable;
                }
                baos.close();
                return bais;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bais;
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchWindow dwindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = dwindow.getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
        ++exampleCount;
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.model1) {
            this.modelSelected = 1;
            this.setFileName("emptyModel" + exampleCount + ".logic");
        } else {
            this.modelSelected = 2;
            this.setFileName("fourBitAdder" + exampleCount + ".logic");
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

