/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicDiagram;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.Wire;

public class DeleteCommand
extends Command {
    private LogicSubpart child;
    private LogicDiagram parent;
    private LogicGuide vGuide;
    private LogicGuide hGuide;
    private int vAlign;
    private int hAlign;
    private int index = -1;
    private final List<Wire> sourceConnections = new ArrayList<Wire>();
    private final List<Wire> targetConnections = new ArrayList<Wire>();

    public DeleteCommand() {
        super(LogicMessages.DeleteCommand_Label);
    }

    private void deleteConnections(LogicSubpart part) {
        if (part instanceof LogicDiagram) {
            LogicDiagram ld = (LogicDiagram)part;
            ld.getChildren().forEach(c -> this.deleteConnections((LogicSubpart)c));
        }
        this.sourceConnections.addAll(part.getSourceConnections());
        for (Wire wire : this.sourceConnections) {
            wire.detachSource();
            wire.detachTarget();
        }
        this.targetConnections.addAll(part.getTargetConnections());
        for (Wire wire : this.targetConnections) {
            wire.detachSource();
            wire.detachTarget();
        }
    }

    private void detachFromGuides(LogicSubpart part) {
        if (part.getVerticalGuide() != null) {
            this.vGuide = part.getVerticalGuide();
            this.vAlign = this.vGuide.getAlignment(part);
            this.vGuide.detachPart(part);
        }
        if (part.getHorizontalGuide() != null) {
            this.hGuide = part.getHorizontalGuide();
            this.hAlign = this.hGuide.getAlignment(part);
            this.hGuide.detachPart(part);
        }
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.detachFromGuides(this.child);
        this.index = this.parent.getChildren().indexOf(this.child);
        this.parent.removeChild(this.child);
    }

    private void reattachToGuides(LogicSubpart part) {
        if (this.vGuide != null) {
            this.vGuide.attachPart(part, this.vAlign);
        }
        if (this.hGuide != null) {
            this.hGuide.attachPart(part, this.hAlign);
        }
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        for (Wire wire : this.sourceConnections) {
            wire.attachSource();
            wire.attachTarget();
        }
        this.sourceConnections.clear();
        for (Wire wire : this.targetConnections) {
            wire.attachSource();
            wire.attachTarget();
        }
        this.targetConnections.clear();
    }

    public void setChild(LogicSubpart c) {
        this.child = c;
    }

    public void setParent(LogicDiagram p) {
        this.parent = p;
    }

    public void undo() {
        this.parent.addChild(this.child, this.index);
        this.restoreConnections();
        this.reattachToGuides(this.child);
    }
}

