/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.util;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.Messages;
import java.util.ArrayList;
import java.util.List;

public class ValidationEventCollector
implements ValidationEventHandler {
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();

    public ValidationEvent[] getEvents() {
        return this.events.toArray(new ValidationEvent[0]);
    }

    public void reset() {
        this.events.clear();
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    @Override
    public boolean handleEvent(ValidationEvent event) {
        this.events.add(event);
        boolean retVal = true;
        switch (event.getSeverity()) {
            case 0: 
            case 1: {
                retVal = true;
                break;
            }
            case 2: {
                retVal = false;
                break;
            }
            default: {
                ValidationEventCollector._assert(false, Messages.format("ValidationEventCollector.UnrecognizedSeverity", event.getSeverity()));
            }
        }
        return retVal;
    }

    private static void _assert(boolean b, String msg) {
        if (!b) {
            throw new InternalError(msg);
        }
    }
}

