/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public final class JavaDeleteProcessor
extends DeleteProcessor
implements IScriptableRefactoring,
ICommentProvider {
    private static final String ATTRIBUTE_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENTS = "elements";
    private static final String ATTRIBUTE_SUGGEST_ACCESSORS = "accessors";
    private static final String ATTRIBUTE_DELETE_SUBPACKAGES = "subPackages";
    private boolean fAccessorsDeleted;
    private boolean fWasCanceled;
    private boolean fSuggestGetterSetterDeletion;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaScriptElement[] fJavaElements;
    private IReorgQueries fDeleteQueries;
    private DeleteModifications fDeleteModifications;
    private String fComment;
    private Change fDeleteChange;
    private boolean fDeleteSubPackages;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.DeleteProcessor";

    public JavaDeleteProcessor(Object[] elements) {
        this.fElements = elements;
        if (this.fElements != null) {
            this.fResources = RefactoringAvailabilityTester.getResources(elements);
            this.fJavaElements = RefactoringAvailabilityTester.getJavaElements(elements);
        }
        this.fSuggestGetterSetterDeletion = true;
        this.fDeleteSubPackages = false;
        this.fWasCanceled = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fJavaElements.length) {
            return false;
        }
        int i = 0;
        while (i < this.fResources.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fResources[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fJavaElements.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fJavaElements[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fJavaElements != null) {
            int i = 0;
            while (i < this.fJavaElements.length) {
                int type = this.fJavaElements[i].getElementType();
                if (type <= 6) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteRefactoring_7;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fDeleteModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fJavaElements);
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fResources);
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public void setSuggestGetterSetterDeletion(boolean suggest) {
        this.fSuggestGetterSetterDeletion = suggest;
    }

    public void setDeleteSubPackages(boolean selection) {
        this.fDeleteSubPackages = selection;
    }

    public boolean getDeleteSubPackages() {
        return this.fDeleteSubPackages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSubPackagesToDelete() {
        try {
            int i = 0;
            while (true) {
                IPackageFragment packageFragment;
                if (i >= this.fJavaElements.length) {
                    return false;
                }
                if (this.fJavaElements[i] instanceof IPackageFragment && !(packageFragment = (IPackageFragment)this.fJavaElements[i]).isDefaultPackage() && packageFragment.hasSubpackages()) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
        }
        return false;
    }

    public void setQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fDeleteQueries = queries;
    }

    public IJavaScriptElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        Assert.isNotNull((Object)this.fDeleteQueries);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotLinked(this.fResources))));
        IResource[] javaResources = ReorgUtils.getResources(this.fJavaElements);
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaScriptElement element = this.fJavaElements[i];
            if (element instanceof IType) {
                ((IType)element).isAnonymous();
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.DeleteRefactoring_1, 1);
        try {
            this.fWasCanceled = false;
            RefactoringStatus result = new RefactoringStatus();
            this.recalculateElementsToDelete();
            this.checkDirtyCompilationUnits(result);
            this.checkDirtyResources(result);
            this.fDeleteModifications = new DeleteModifications();
            this.fDeleteModifications.delete(this.fResources);
            this.fDeleteModifications.delete(this.fJavaElements);
            List packageDeletes = this.fDeleteModifications.postProcess();
            TextChangeManager manager = new TextChangeManager();
            this.fDeleteChange = DeleteChangeCreator.createDeleteChange(manager, this.fResources, this.fJavaElements, this.getProcessorName(), packageDeletes);
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fDeleteModifications.buildDelta(deltaFactory);
            IFile[] files = ResourceUtil.getFiles(manager.getAllCompilationUnits());
            int i = 0;
            while (i < files.length) {
                deltaFactory.change(files[i]);
                ++i;
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (OperationCanceledException e) {
            this.fWasCanceled = true;
            throw e;
        }
        catch (JavaScriptModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
        finally {
            pm.done();
        }
    }

    private void checkDirtyCompilationUnits(RefactoringStatus result) throws CoreException {
        if (this.fJavaElements == null || this.fJavaElements.length == 0) {
            return;
        }
        int je = 0;
        while (je < this.fJavaElements.length) {
            IJavaScriptElement element = this.fJavaElements[je];
            if (element instanceof IJavaScriptUnit) {
                this.checkDirtyCompilationUnit(result, (IJavaScriptUnit)element);
            } else if (element instanceof IPackageFragment) {
                IJavaScriptUnit[] units = ((IPackageFragment)element).getJavaScriptUnits();
                int u = 0;
                while (u < units.length) {
                    this.checkDirtyCompilationUnit(result, units[u]);
                    ++u;
                }
            }
            ++je;
        }
    }

    private void checkDirtyCompilationUnit(RefactoringStatus result, IJavaScriptUnit cunit) {
        IResource resource = cunit.getResource();
        if (resource == null || resource.getType() != 1) {
            return;
        }
        this.checkDirtyFile(result, (IFile)resource);
    }

    private void checkDirtyResources(final RefactoringStatus result) throws CoreException {
        int i = 0;
        while (i < this.fResources.length) {
            IResource resource = this.fResources[i];
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource visitedResource) throws CoreException {
                    if (visitedResource instanceof IFile) {
                        JavaDeleteProcessor.this.checkDirtyFile(result, (IFile)visitedResource);
                    }
                    return true;
                }
            }, 2, false);
            ++i;
        }
    }

    private void checkDirtyFile(RefactoringStatus result, IFile file) {
        if (file == null || !file.exists()) {
            return;
        }
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty()) {
            if (buffer.isStateValidated() && buffer.isSynchronized()) {
                result.addWarning(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            } else {
                result.addFatalError(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, file.getFullPath().toString()));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        this.fAccessorsDeleted = false;
        if (this.fDeleteSubPackages) {
            this.addSubPackages();
        }
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
        this.addDeletableParentPackagesOnPackageDeletion();
    }

    private void addSubPackages() throws JavaScriptModelException {
        HashSet<Object> javaElements = new HashSet<Object>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            if (this.fJavaElements[i] instanceof IPackageFragment) {
                javaElements.addAll(Arrays.asList(JavaElementUtil.getPackageAndSubpackages((IPackageFragment)this.fJavaElements[i])));
            } else {
                javaElements.add(this.fJavaElements[i]);
            }
            ++i;
        }
        this.fJavaElements = javaElements.toArray(new IJavaScriptElement[javaElements.size()]);
    }

    private void addDeletableParentPackagesOnPackageDeletion() throws CoreException {
        List initialPackagesToDelete = ReorgUtils.getElementsOfType(this.fJavaElements, 4);
        if (initialPackagesToDelete.size() == 0) {
            return;
        }
        Collections.sort(initialPackagesToDelete, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IPackageFragment one = (IPackageFragment)arg0;
                IPackageFragment two = (IPackageFragment)arg1;
                return two.getElementName().compareTo(one.getElementName());
            }
        });
        HashSet<IResource> deletedChildren = new HashSet<IResource>();
        deletedChildren.addAll(Arrays.asList(this.fResources));
        int i = 0;
        while (i < this.fJavaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(this.fJavaElements[i])) {
                deletedChildren.add(this.fJavaElements[i].getResource());
            }
            ++i;
        }
        ArrayList<Object> allFragmentsToDelete = new ArrayList<Object>();
        for (IPackageFragment currentPackageFragment : initialPackagesToDelete) {
            IPackageFragment parent;
            allFragmentsToDelete.add(currentPackageFragment);
            if (!this.canRemoveCompletely(currentPackageFragment, initialPackagesToDelete) || (parent = JavaElementUtil.getParentSubpackage(currentPackageFragment)) == null || initialPackagesToDelete.contains(parent)) continue;
            ArrayList emptyParents = new ArrayList();
            this.addDeletableParentPackages(parent, initialPackagesToDelete, deletedChildren, emptyParents);
            allFragmentsToDelete.addAll(emptyParents);
        }
        ArrayList<Object> javaElements = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < this.fJavaElements.length) {
            IPackageFragment frag;
            if (!(this.fJavaElements[i2] instanceof IPackageFragment) && !allFragmentsToDelete.contains(frag = (IPackageFragment)this.fJavaElements[i2].getAncestor(4))) {
                javaElements.add(this.fJavaElements[i2]);
            }
            ++i2;
        }
        javaElements.addAll(allFragmentsToDelete);
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i3 = 0;
        while (i3 < this.fResources.length) {
            IResource parent = this.fResources[i3];
            if (parent.getType() == 1) {
                parent = parent.getParent();
            }
            if (!deletedChildren.contains(parent)) {
                resources.add(this.fResources[i3]);
            }
            ++i3;
        }
        this.fJavaElements = javaElements.toArray(new IJavaScriptElement[javaElements.size()]);
        this.fResources = resources.toArray(new IResource[resources.size()]);
    }

    private boolean canRemoveCompletely(IPackageFragment pack, List packagesToDelete) throws JavaScriptModelException {
        IPackageFragment[] subPackages = JavaElementUtil.getPackageAndSubpackages(pack);
        int i = 0;
        while (i < subPackages.length) {
            if (!subPackages[i].equals(pack) && !packagesToDelete.contains(subPackages[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addDeletableParentPackages(IPackageFragment frag, List initialPackagesToDelete, Set resourcesToDelete, List deletableParentPackages) throws CoreException {
        IConfirmQuery query;
        if (frag.getResource().isLinked() && !(query = this.fDeleteQueries.createYesNoQuery(RefactoringCoreMessages.JavaDeleteProcessor_confirm_linked_folder_delete, false, 8)).confirm(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_delete_linked_folder_question, new String[]{frag.getResource().getName()}))) {
            return;
        }
        IResource[] children = ((IContainer)frag.getResource()).members();
        int i = 0;
        while (i < children.length) {
            if (!resourcesToDelete.contains(children[i])) {
                return;
            }
            ++i;
        }
        resourcesToDelete.add(frag.getResource());
        deletableParentPackages.add(frag);
        IPackageFragment parent = JavaElementUtil.getParentSubpackage(frag);
        if (parent != null && !initialPackagesToDelete.contains(parent)) {
            this.addDeletableParentPackages(parent, initialPackagesToDelete, resourcesToDelete, deletableParentPackages);
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaScriptModelException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_2;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(query);
        this.removeUnconfirmedReferencedArchiveFiles(query);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery query) throws JavaScriptModelException, OperationCanceledException {
        ArrayList<IResource> filesToSkip = new ArrayList<IResource>(0);
        int i = 0;
        while (i < this.fResources.length) {
            List<IJavaScriptProject> referencingProjects;
            IPackageFragmentRoot root;
            IJavaScriptProject project;
            IResource resource = this.fResources[i];
            if (resource instanceof IFile && (project = JavaScriptCore.create((IProject)resource.getProject())) != null && project.exists() && (root = project.findPackageFragmentRoot(resource.getFullPath())) != null && JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects = Arrays.asList(JavaElementUtil.getReferencingProjects(root)))) {
                filesToSkip.add(resource);
            }
            ++i;
        }
        this.removeFromSetToDelete((IResource[])filesToSkip.toArray(new IFile[filesToSkip.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery query) throws JavaScriptModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> rootsToSkip = new ArrayList<IPackageFragmentRoot>(0);
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaScriptElement element = this.fJavaElements[i];
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                ArrayList<IJavaScriptProject> referencingProjects = new ArrayList<IJavaScriptProject>(Arrays.asList(JavaElementUtil.getReferencingProjects(root)));
                referencingProjects.remove(root.getJavaScriptProject());
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(query, root, referencingProjects)) {
                    rootsToSkip.add(root);
                }
            }
            ++i;
        }
        this.removeFromSetToDelete(rootsToSkip.toArray(new IJavaScriptElement[rootsToSkip.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery query, IPackageFragmentRoot root, List referencingProjects) throws OperationCanceledException {
        if (referencingProjects.isEmpty() || root == null || !root.exists() || !root.isArchive()) {
            return false;
        }
        String question = Messages.format(RefactoringCoreMessages.DeleteRefactoring_3, root.getElementName());
        return !query.confirm(question, referencingProjects.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_4;
        IConfirmQuery query = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 4);
        ArrayList<IFolder> foldersToSkip = new ArrayList<IFolder>(0);
        int i = 0;
        while (i < this.fResources.length) {
            String question;
            IFolder folder;
            IResource resource = this.fResources[i];
            if (resource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(folder = (IFolder)resource) && !query.confirm(question = Messages.format(RefactoringCoreMessages.DeleteRefactoring_5, folder.getName()))) {
                foldersToSkip.add(folder);
            }
            ++i;
        }
        this.removeFromSetToDelete(foldersToSkip.toArray(new IResource[foldersToSkip.size()]));
    }

    private static boolean containsSourceFolder(IFolder folder) throws CoreException {
        IResource[] subFolders = folder.members();
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i] instanceof IFolder) {
                IJavaScriptElement element = JavaScriptCore.create((IFolder)folder);
                if (element instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(element instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)subFolders[i])) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentUtil.getJavaElements();
        this.fResources = parentUtil.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentUtil = new ParentChecker(this.fResources, this.fJavaElements);
        parentUtil.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentUtil.getJavaElements();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.JavaDeleteProcessor_creating_change, 1);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String description = this.fElements.length == 1 ? RefactoringCoreMessages.JavaDeleteProcessor_description_singular : RefactoringCoreMessages.JavaDeleteProcessor_description_plural;
            IProject resource = this.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_project_pattern, project) : RefactoringCoreMessages.JavaDeleteProcessor_workspace;
            String header = Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_header, new String[]{String.valueOf(this.fElements.length), source});
            int flags = 589830;
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            if (this.fDeleteSubPackages) {
                comment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_subpackages);
            }
            if (this.fAccessorsDeleted) {
                comment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_accessors);
            }
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.delete", project, description, comment.asString(), arguments, flags);
            arguments.put(ATTRIBUTE_DELETE_SUBPACKAGES, Boolean.valueOf(this.fDeleteSubPackages).toString());
            arguments.put(ATTRIBUTE_SUGGEST_ACCESSORS, Boolean.valueOf(this.fSuggestGetterSetterDeletion).toString());
            arguments.put(ATTRIBUTE_RESOURCES, Integer.valueOf(this.fResources.length).toString());
            int offset = 0;
            while (offset < this.fResources.length) {
                arguments.put("element" + (offset + 1), descriptor.resourceToHandle(this.fResources[offset]));
                ++offset;
            }
            arguments.put(ATTRIBUTE_ELEMENTS, Integer.valueOf(this.fJavaElements.length).toString());
            offset = 0;
            while (offset < this.fJavaElements.length) {
                arguments.put("element" + (offset + this.fResources.length + 1), descriptor.elementToHandle(this.fJavaElements[offset]));
                ++offset;
            }
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.DeleteRefactoring_7, new Change[]{this.fDeleteChange});
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    private IProject getSingleProject() {
        IProject first = null;
        int index = 0;
        while (index < this.fElements.length) {
            IProject project = null;
            if (this.fElements[index] instanceof IJavaScriptElement) {
                project = ((IJavaScriptElement)this.fElements[index]).getJavaScriptProject().getProject();
            } else if (this.fElements[index] instanceof IResource) {
                project = ((IResource)this.fElements[index]).getProject();
            }
            if (project != null) {
                if (first == null) {
                    first = project;
                } else if (!project.equals((Object)first)) {
                    return null;
                }
            }
            ++index;
        }
        return first;
    }

    private void addToSetToDelete(IJavaScriptElement[] newElements) {
        this.fJavaElements = ReorgUtils.union(this.fJavaElements, newElements);
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaScriptElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }

    private void addGettersSetters() throws JavaScriptModelException {
        IField[] fields = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (fields.length == 0) {
            return;
        }
        Map getterSetterMapping = JavaDeleteProcessor.createGetterSetterMapping(fields);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(getterSetterMapping);
        if (getterSetterMapping.isEmpty()) {
            return;
        }
        this.fAccessorsDeleted = true;
        List gettersSettersToAdd = this.getGettersSettersToDelete(getterSetterMapping);
        this.addToSetToDelete((IJavaScriptElement[])gettersSettersToAdd.toArray(new IFunction[gettersSettersToAdd.size()]));
    }

    private List getGettersSettersToDelete(Map getterSetterMapping) {
        ArrayList<IFunction> gettersSettersToAdd = new ArrayList<IFunction>(getterSetterMapping.size());
        String queryTitle = RefactoringCoreMessages.DeleteRefactoring_8;
        IConfirmQuery getterSetterQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(queryTitle, true, 1);
        for (IField field : getterSetterMapping.keySet()) {
            Assert.isTrue((JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field) ? 1 : 0) != 0);
            String deleteGetterSetter = Messages.format(RefactoringCoreMessages.DeleteRefactoring_9, JavaElementUtil.createFieldSignature(field));
            if (!getterSetterQuery.confirm(deleteGetterSetter)) continue;
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field)) {
                gettersSettersToAdd.add(JavaDeleteProcessor.getGetter(getterSetterMapping, field));
            }
            if (!JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            gettersSettersToAdd.add(JavaDeleteProcessor.getSetter(getterSetterMapping, field));
        }
        return gettersSettersToAdd;
    }

    private void removeAlreadySelectedMethods(Map getterSetterMapping) {
        List<IJavaScriptElement> elementsToDelete = Arrays.asList(this.fJavaElements);
        Iterator iter = getterSetterMapping.keySet().iterator();
        while (iter.hasNext()) {
            IFunction setter;
            IField field = (IField)iter.next();
            IFunction getter = JavaDeleteProcessor.getGetter(getterSetterMapping, field);
            if (getter != null && elementsToDelete.contains(getter)) {
                JavaDeleteProcessor.removeGetterFromMapping(getterSetterMapping, field);
            }
            if ((setter = JavaDeleteProcessor.getSetter(getterSetterMapping, field)) != null && elementsToDelete.contains(setter)) {
                JavaDeleteProcessor.removeSetterFromMapping(getterSetterMapping, field);
            }
            if (JavaDeleteProcessor.hasGetter(getterSetterMapping, field) || JavaDeleteProcessor.hasSetter(getterSetterMapping, field)) continue;
            iter.remove();
        }
    }

    private static Map createGetterSetterMapping(IField[] fields) throws JavaScriptModelException {
        HashMap<IField, IFunction[]> result = new HashMap<IField, IFunction[]>();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            IFunction[] getterSetter = JavaDeleteProcessor.getGetterSetter(field);
            if (getterSetter != null) {
                result.put(field, getterSetter);
            }
            ++i;
        }
        return result;
    }

    private static boolean hasSetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getSetter(getterSetterMapping, field) != null;
    }

    private static boolean hasGetter(Map getterSetterMapping, IField field) {
        return getterSetterMapping.containsKey(field) && JavaDeleteProcessor.getGetter(getterSetterMapping, field) != null;
    }

    private static void removeGetterFromMapping(Map getterSetterMapping, IField field) {
        ((IFunction[])getterSetterMapping.get((Object)field))[0] = null;
    }

    private static void removeSetterFromMapping(Map getterSetterMapping, IField field) {
        ((IFunction[])getterSetterMapping.get((Object)field))[1] = null;
    }

    private static IFunction getGetter(Map getterSetterMapping, IField field) {
        return ((IFunction[])getterSetterMapping.get(field))[0];
    }

    private static IFunction getSetter(Map getterSetterMapping, IField field) {
        return ((IFunction[])getterSetterMapping.get(field))[1];
    }

    private static IField[] getFields(IJavaScriptElement[] elements) {
        ArrayList<IJavaScriptElement> fields = new ArrayList<IJavaScriptElement>(3);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IField) {
                fields.add(elements[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private static IFunction[] getGetterSetter(IField field) throws JavaScriptModelException {
        IFunction getter = GetterSetterUtil.getGetter(field);
        IFunction setter = GetterSetterUtil.getSetter(field);
        if (getter != null && getter.exists() || setter != null && setter.exists()) {
            return new IFunction[]{getter, setter};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaScriptModelException {
        Set cusToEmpty = this.getCusToEmpty();
        this.addToSetToDelete((IJavaScriptElement[])cusToEmpty.toArray(new IJavaScriptUnit[cusToEmpty.size()]));
    }

    private Set getCusToEmpty() throws JavaScriptModelException {
        HashSet<IJavaScriptUnit> result = new HashSet<IJavaScriptUnit>();
        int i = 0;
        while (i < this.fJavaElements.length) {
            IJavaScriptElement element = this.fJavaElements[i];
            IJavaScriptUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu != null && !result.contains(cu) && this.willHaveAllTopLevelTypesDeleted(cu)) {
                result.add(cu);
            }
            ++i;
        }
        return result;
    }

    private boolean willHaveAllTopLevelTypesDeleted(IJavaScriptUnit cu) throws JavaScriptModelException {
        HashSet<IJavaScriptElement> elementSet = new HashSet<IJavaScriptElement>(Arrays.asList(this.fJavaElements));
        IType[] topLevelTypes = cu.getTypes();
        int i = 0;
        while (i < topLevelTypes.length) {
            if (!elementSet.contains(topLevelTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean canEnableComment() {
        return true;
    }

    @Override
    public String getComment() {
        return this.fComment;
    }

    @Override
    public void setComment(String comment) {
        this.fComment = comment;
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        ArrayList<Object> elements;
        this.setQueries(new NullReorgQueries());
        RefactoringStatus status = new RefactoringStatus();
        if (arguments instanceof JavaRefactoringArguments) {
            String attribute;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String subPackages = extended.getAttribute(ATTRIBUTE_DELETE_SUBPACKAGES);
            if (subPackages == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE_SUBPACKAGES));
            }
            this.fDeleteSubPackages = Boolean.valueOf(subPackages);
            String suggest = extended.getAttribute(ATTRIBUTE_SUGGEST_ACCESSORS);
            if (suggest == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SUGGEST_ACCESSORS));
            }
            this.fSuggestGetterSetterDeletion = Boolean.valueOf(suggest);
            int resourceCount = 0;
            int elementCount = 0;
            String value = extended.getAttribute(ATTRIBUTE_RESOURCES);
            if (value != null && !"".equals(value)) {
                try {
                    resourceCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
            }
            value = extended.getAttribute(ATTRIBUTE_ELEMENTS);
            if (value != null && !"".equals(value)) {
                try {
                    elementCount = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
            }
            String handle = null;
            elements = new ArrayList<Object>();
            int index = 0;
            while (index < resourceCount) {
                attribute = "element" + (index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IResource resource = JDTRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                    if (resource == null || !resource.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(resource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.delete"));
                    } else {
                        elements.add(resource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
            this.fResources = elements.toArray(new IResource[elements.size()]);
            elements = new ArrayList();
            index = 0;
            while (index < elementCount) {
                attribute = "element" + (resourceCount + index + 1);
                handle = extended.getAttribute(attribute);
                if (handle != null && !"".equals(handle)) {
                    IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                    if (element == null || !element.exists()) {
                        status.merge(ScriptableRefactoring.createInputWarningStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.delete"));
                    } else {
                        elements.add(element);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, attribute));
                }
                ++index;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fJavaElements = elements.toArray(new IJavaScriptElement[elements.size()]);
        this.fElements = new Object[this.fResources.length + this.fJavaElements.length];
        System.arraycopy(this.fResources, 0, this.fElements, 0, this.fResources.length);
        System.arraycopy(this.fJavaElements, 0, this.fElements, this.fResources.length, this.fJavaElements.length);
        return status;
    }
}

