/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.explorer;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.provisional.cheatsheets.ICompositeCheatSheet;

public class RestartAllAction
extends Action {
    private final ICompositeCheatSheet model;

    public RestartAllAction(ICompositeCheatSheet model) {
        this.model = model;
        this.setText(Messages.RESTART_ALL_MENU);
        IPath path = CheatSheetPlugin.ICONS_PATH.append("elcl16/").append("restart_all.png");
        ImageDescriptor restartImage = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        this.setImageDescriptor(restartImage);
    }

    public void run() {
        if (RestartAllAction.confirmRestart()) {
            ((CompositeCheatSheetModel)this.model).resetAllTasks(null);
        }
    }

    public static boolean confirmRestart() {
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.COMPOSITE_RESTART_DIALOG_TITLE, (String)Messages.COMPOSITE_RESTART_CONFIRM_MESSAGE);
    }
}

