/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PlatformModule {
    public static final String MODULE_ID = "/System/Platform";

    @WrapToScript
    public static Object adapt(Object source, Class<?> target) {
        return Platform.getAdapterManager().getAdapter(source, target);
    }

    @WrapToScript
    public static Object getService(Class<?> type) {
        return PlatformUI.getWorkbench().getService(type);
    }

    @WrapToScript
    public static void executeCommand(String commandId, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Map<String, String> parameters) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        HashMap commandParameters = parameters != null ? parameters : new HashMap();
        ICommandService commandService = (ICommandService)PlatformModule.getService(ICommandService.class);
        IEvaluationService evaluationService = (IEvaluationService)PlatformModule.getService(IEvaluationService.class);
        Command command = commandService.getCommand(commandId);
        command.executeWithChecks(new ExecutionEvent(command, commandParameters, null, (Object)evaluationService.getCurrentState()));
    }

    @WrapToScript
    public static String getSystemProperty(String key) {
        String value = System.getProperty(key);
        return value != null ? value : System.getenv(key);
    }

    @WrapToScript
    public static Process runProcess(String name, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String[] args, @ScriptParameter(defaultValue="system.out") String output, @ScriptParameter(defaultValue="system.err") String error) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(name);
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                arguments.add(arg);
                ++n2;
            }
        }
        ProcessBuilder builder = new ProcessBuilder(arguments);
        if (output == null) {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        } else if ("system.out".equalsIgnoreCase(output)) {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        } else if (!"keep".equalsIgnoreCase(output)) {
            builder.redirectOutput(new File(output));
        }
        if (error == null) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        } else if ("system.err".equalsIgnoreCase(error)) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        } else if (!"keep".equalsIgnoreCase(error)) {
            builder.redirectError(new File(error));
        }
        return builder.start();
    }

    @WrapToScript
    public static Object readPreferences(String node, String key, @ScriptParameter(defaultValue="") Object defaultValue) {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(node);
        if (root != null) {
            if (defaultValue instanceof Boolean) {
                return root.getBoolean(key, ((Boolean)defaultValue).booleanValue());
            }
            if (defaultValue instanceof Integer) {
                return root.getInt(key, ((Integer)defaultValue).intValue());
            }
            if (defaultValue instanceof Double) {
                return root.getDouble(key, ((Double)defaultValue).doubleValue());
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(root.getFloat(key, ((Float)defaultValue).floatValue()));
            }
            if (defaultValue instanceof Long) {
                return root.getLong(key, ((Long)defaultValue).longValue());
            }
            if (defaultValue instanceof byte[]) {
                return root.getByteArray(key, (byte[])defaultValue);
            }
            return root.get(key, defaultValue != null ? defaultValue.toString() : "");
        }
        return null;
    }

    @WrapToScript
    public static void writePreferences(String node, String key, Object value) {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(node);
        if (root != null) {
            if (value instanceof Boolean) {
                root.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Integer) {
                root.putInt(key, ((Integer)value).intValue());
            } else if (value instanceof Double) {
                root.putDouble(key, ((Double)value).doubleValue());
            } else if (value instanceof Float) {
                root.putFloat(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                root.putLong(key, ((Long)value).longValue());
            } else if (value instanceof byte[]) {
                root.putByteArray(key, (byte[])value);
            } else {
                root.put(key, value != null ? value.toString() : "");
            }
        }
    }

    @WrapToScript
    public static void postEvent(final String topic, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object data, @ScriptParameter(defaultValue="0") long delay) {
        if (delay > 0L) {
            Job job = new Job("Post event"){

                protected IStatus run(IProgressMonitor monitor) {
                    PlatformModule.postEvent(topic, data, 0L);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(delay);
        } else {
            IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
            if (service != null) {
                service.post(topic, data);
            } else {
                throw new RuntimeException("Broker service not available");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public static Event waitForEvent(String topic, @ScriptParameter(defaultValue="0") long timeout) throws InterruptedException {
        IEventBroker service = (IEventBroker)PlatformUI.getWorkbench().getService(IEventBroker.class);
        if (service != null) {
            WaitingEventHandler handler;
            WaitingEventHandler waitingEventHandler = handler = new WaitingEventHandler();
            synchronized (waitingEventHandler) {
                service.subscribe(topic, (EventHandler)handler);
                handler.wait(timeout);
                service.unsubscribe((EventHandler)handler);
                return handler.fEvent;
            }
        }
        throw new RuntimeException("Broker service not available");
    }

    private static class WaitingEventHandler
    implements EventHandler {
        private Event fEvent = null;

        private WaitingEventHandler() {
        }

        public synchronized void handleEvent(Event event) {
            this.fEvent = event;
            this.notify();
        }
    }
}

